/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.http;

import com.easou.novel.searchclient.util.ConfigUtil;
import com.easou.novel.searchclient.util.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HttpClientManager {
    private static final int MAX_TOTAL_DEFAULT = 100;
    private static final int MAX_PER_ROUTER_DEFAULT = 50;
    private static final int CONN_TIMEOUT_DEFAULT = 500;
    private static final int SOCKET_TIMEOUT_DEFAULT = 500;
    private static final int HTTP_KEEPLIVE_DEFAULT = 60001;
    private static CloseableHttpClient httpClient = null;
    private static HttpClientManager httpClientManager = new HttpClientManager();

    private HttpClientManager() {
        this.initHttpClient();
    }

    public static HttpClientManager getInstance() {
        return httpClientManager;
    }

    public CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    private void initHttpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(ConfigUtil.getInt("httpclient.maxTotal", 100));
        cm.setDefaultMaxPerRoute(ConfigUtil.getInt("httpclient.maxPerRouter", 50));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(ConfigUtil.getInt("httpclient.timeoutConnection", 500)).setSocketTimeout(ConfigUtil.getInt("httpclient.timeoutSocket", 500)).build();
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long keepAlive = super.getKeepAliveDuration(response, context);
                if (keepAlive == -1L) {
                    keepAlive = ConfigUtil.getInt("httpclient.keeplive", 60001);
                }
                LogFactory.LOGPOOL.info(new Object[]{"HttpClientManager init,keeplive :", keepAlive});
                return keepAlive;
            }
        };
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
    }
}

