/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.http;

import com.easou.novel.searchclient.http.HttpClientManager;
import com.easou.novel.searchclient.util.GsonUtil;
import com.easou.novel.searchclient.util.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;

public class HttpExecutor {
    private String url = null;
    private HttpUriRequest httpRequest = null;
    private CloseableHttpResponse response = null;
    private InputStream inputStream = null;
    HttpClient httpClient = HttpClientManager.getInstance().getHttpClient();

    public HttpExecutor(String url) {
        this.url = url;
        this.httpRequest = new HttpGet(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getHttpBody() {
        startTime = System.currentTimeMillis();
        body = null;
        statuCode = 0;
        try {
            this.response = (CloseableHttpResponse)this.httpClient.execute(this.httpRequest);
            statuCode = this.response.getStatusLine().getStatusCode();
            entity = this.response.getEntity();
            if (entity != null) {
                this.inputStream = entity.getContent();
            }
            if (statuCode == 200) {
                body = IOUtils.toString((InputStream)this.inputStream, (String)"utf-8");
            } else {
                this.httpRequest.abort();
                body = "";
            }
            ** if (this.inputStream == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                this.httpRequest.abort();
                LogFactory.LOGPOOL.info(new Object[]{"HttpExecutor > url exec Exception:" + this.url, e});
                ** if (this.inputStream == null) goto lbl-1000
            }
            catch (Throwable var6_8) {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        LogFactory.LOGPOOL.info(new Object[]{"HttpExecutor > url ioclose Exception:", this.url, e});
                    }
                }
                throw var6_8;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    LogFactory.LOGPOOL.info(new Object[]{"HttpExecutor > url ioclose Exception:", this.url, e});
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                LogFactory.LOGPOOL.info(new Object[]{"HttpExecutor > url ioclose Exception:", this.url, e});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        LogFactory.LOGPOOL.debug(new Object[]{"HttpExecutor > costTime:", System.currentTimeMillis() - startTime, ",", statuCode, ",body:", body != null ? Integer.valueOf(body.length()) : Boolean.valueOf(false), ",url:", this.url});
        return body;
    }

    public void abort() {
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                LogFactory.LOGPOOL.info(new Object[]{"HttpExecutor > url abort() Exception:", this.url, e});
            }
        }
    }

    public JSONObject getBodyForJsonObj() {
        String body = this.getHttpBody();
        JSONObject jsonRoot = new JSONObject(body);
        return jsonRoot;
    }

    public <T> T getBodyForJObj(Class<T> clazz) {
        String body = this.getHttpBody();
        T t = GsonUtil.fromJson(body, clazz);
        return t;
    }

    private String getCharset(HttpEntity entity) {
        String charset = null;
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        Charset charsets = contentType.getCharset();
        charset = null != charsets ? charsets.toString() : "utf-8";
        return charset;
    }

    private boolean isGzip(HttpEntity entity) {
        Header header = entity.getContentEncoding();
        boolean isGzip = false;
        if (null != header) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!headerElement.getName().equalsIgnoreCase("gzip")) continue;
                isGzip = true;
            }
        }
        return isGzip;
    }
}

