/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.impl;

import com.easou.novel.searchclient.impl.SearchClientImpl;
import com.easou.novel.searchclient.model.AppId;
import com.easou.novel.searchclient.model.MixSearchResponse;
import com.easou.novel.searchclient.model.NovelGid;
import com.easou.novel.searchclient.model.SearchParam;
import com.easou.novel.searchclient.util.ConfigUtil;
import com.easou.novel.searchclient.util.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class MixClientImpl
extends SearchClientImpl<MixSearchResponse> {
    private static final String SERVER = "http://" + ConfigUtil.getSysConfig().get("search.server.domain") + ConfigUtil.getSysConfig().get("search.server.mixcontext");
    private static final String NEW_SERVER = "http://" + ConfigUtil.getSysConfig().get("weijuan.search.server.domain") + ConfigUtil.getSysConfig().get("search.server.mixcontext");
    private static final String CARTOON_SERVER = "http://" + ConfigUtil.getSysConfig().get("cartoon.search.server.domain") + ConfigUtil.getSysConfig().get("cartoon.search.server.mixcontext");

    @Override
    protected MixSearchResponse parseResponse(String content) {
        MixSearchResponse response = new MixSearchResponse();
        try {
            JSONObject root = new JSONObject(content);
            response.setTotal(root.optInt("total", 0));
            response.setCheckWord(root.optString("check_word", ""));
            response.setKeyWord(root.optString("keyWord", ""));
            response.setSearchType(root.optInt("type", 0));
            response.setSortType(root.optInt("sortType", 0));
            response.setDisplayRecm((short)root.optInt("displayRecm", 0));
            JSONArray novelGid = root.optJSONArray("items");
            response.setNovelGid(this.convert2Gid(novelGid));
        }
        catch (Exception e) {
            LogFactory.LOG.error(new Object[]{this.getClass().getSimpleName(), " parseResponse error, content:", content, e});
            e.printStackTrace();
        }
        return response;
    }

    @Override
    protected String getServer() {
        if (this.param == null) {
            return SERVER;
        }
        if (this.param.getAppid() == AppId.WEIJUAN.getValue() || this.param.getAppid() == AppId.WEIJUAN_GIRL.getValue() || this.param.getAppid() == AppId.KUAIDU_IOS.getValue() || this.param.getAppid() == AppId.TXT_MianFeiXiaoShuo.getValue() || this.param.getAppid() == AppId.TXT_MianFeiQuanBen.getValue() || this.param.getAppid() == AppId.QuanBenMianFei.getValue() || this.param.getAppid() == AppId.AIKAN_IOS.getValue() || this.param.getAppid() == AppId.WJ_40006.getValue() || this.param.getAppid() == AppId.QuiKan_IOS.getValue()) {
            return NEW_SERVER;
        }
        if (this.param.getAppid() == AppId.CARTOON.getValue()) {
            return CARTOON_SERVER;
        }
        return SERVER;
    }

    @Override
    protected NovelGid convert2Gid(JSONObject item) {
        NovelGid ngid = super.convert2Gid(item);
        if (ngid != null) {
            ngid.setExportAd(item.optInt("wjType", 0));
        }
        return ngid;
    }

    public MixSearchResponse search(SearchParam param) {
        return (MixSearchResponse)this.doSearch(param);
    }

    public MixSearchResponse search4Vip(SearchParam param) {
        param.setdType("5");
        return (MixSearchResponse)this.doSearch(param);
    }

    public MixSearchResponse searchAll(SearchParam param) {
        param.setdType("0");
        return (MixSearchResponse)this.doSearch(param);
    }
}

