/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.impl;

import com.easou.novel.searchclient.impl.SearchClientImpl;
import com.easou.novel.searchclient.model.NewSearchResponse;
import com.easou.novel.searchclient.model.SearchParam;
import com.easou.novel.searchclient.util.ConfigUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class NewClientImpl
extends SearchClientImpl<NewSearchResponse> {
    private static final String SERVER = "http://" + ConfigUtil.getSysConfig().get("search.server.domain") + ConfigUtil.getSysConfig().get("search.server.newcontext");

    public NewSearchResponse newSearch4Free(SearchParam param) {
        param.setdType("1");
        return (NewSearchResponse)this.doSearch(param);
    }

    public NewSearchResponse newSearch4Charge(SearchParam param) {
        param.setdType("2");
        return (NewSearchResponse)this.doSearch(param);
    }

    public NewSearchResponse newSearchAll(SearchParam param) {
        param.setdType("12");
        return (NewSearchResponse)this.doSearch(param);
    }

    public NewSearchResponse newSearch4Vip(SearchParam param) {
        param.setdType("5");
        return (NewSearchResponse)this.doSearch(param);
    }

    @Override
    protected NewSearchResponse parseResponse(String content) {
        NewSearchResponse response = new NewSearchResponse();
        try {
            JSONObject root = new JSONObject(content);
            response.setPaidTotal(root.optInt("chargeTotal", 0));
            response.setFreeTotal(root.optInt("freeTotal", 0));
            response.setCheckWord(root.optString("check_word", ""));
            response.setKeyWord(root.optString("keyWord", ""));
            response.setSearchType(root.optInt("type", 0));
            response.setSortType(root.optInt("sortType", 0));
            JSONArray paidItems = root.optJSONArray("chargeItems");
            JSONArray freeItems = root.optJSONArray("freeItems");
            response.setPaidNovelGid(this.convert2Gid(paidItems));
            response.setFreeNovelGid(this.convert2Gid(freeItems));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    protected String getServer() {
        return SERVER;
    }
}

