<%@ page contentType="text/html;charset=UTF-8" language="java" isELIgnored="false" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!doctype html>
<html lang="zh">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SDK 调度统计</title>
    <link rel="stylesheet" href="<c:url value='/res/vendors/bootstrap/css/bootstrap.min.css'/>">
    <link rel="stylesheet" href="<c:url value='/res/vendors/font-awesome/css/font-awesome.min.css'/>">
    <link rel="stylesheet" href="<c:url value='/res/vendors/gentelella/css/custom.css'/>">
    <link rel="stylesheet" href="<c:url value='/res/vendors/bootstrap-daterangepicker/daterangepicker.css'/>">
    <link rel="stylesheet" href="<c:url value='/res/vendors/select2-4.0.3/css/select2.min.css'/>">
    <link rel="stylesheet" href="<c:url value="/res/vendors/icheck-1.x/skins/minimal/grey.css"/> ">
    <style>
        body {
            background: url("<c:url value='/res/imgs/wallpaper.png'/>") #FFF;
            padding: 0 10px;
        }

        #platform div {
            margin: 6px 5px
        }
        #platform div .title, div span {
            font-weight: bold;
        }

        #packages div{
            margin: 6px 5px
        }
        #packages div .title, div span {
            font-weight: bold;
        }

        #flowChart{
            -moz-user-select: none;
            -webkit-user-select: none;
            -ms-user-select: none;
        }

        .select2-container--default .select2-selection--single {
            border: 1px solid #ccc;!important;
            border-radius: 0px;!important;
            height: 34px; !important;
            padding: 6px 12px; !important;
            font-size: 14px; !important;
            line-height: 1.42857143; !important;
        }

        .red {
            color: #1ABB9C;
        }

    </style>
</head>
<body>
<div class="row">
    <div class="page-title" style="padding: 10px 17px">
        <div class="title_left">
            <h3>广告平台实时统计<small> 预留60天</small></h3>
        </div>
    </div>
    <div class="clearfix"></div>

    <div class="col-md-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>DAU趋势图</h2>
                <ul class="nav navbar-right panel_toolbox">

                    <li>
                        <div class="title_right">
                            <div style="width: 70px" class="pull-right"></div>
                            <button id="dauReloadBtn" style="margin-top: 9px" type="button" class="btn btn-primary pull-right btn-xs">刷新</button>
                        </div>
                    </li>
                    <li>
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
            <div class="x_content" style="display:block; height: 400px; width: 100%">
                <canvas id="dauChart" style="display:block; height: 400px; width: 100%"></canvas>
            </div>
        </div>
    </div>


    <div class="col-md-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>广告位流量趋势</h2>
                <ul class="nav navbar-right panel_toolbox">

                    <li>
                        <div style="margin-right: 10px; padding-top: 5px">
                            <label style="padding-top: 3px">事件类型：</label>
                            <input type="radio" name="eventType" value="2" checked>调度
                            <input type="radio" name="eventType" value="3">展现
                        </div>
                    </li>

                    <li style="margin-right: 38px">
                        <select id="flow_ad_pos" class="form-control">
                            <option></option>
                            <optgroup label="Android">
                                <option value="5899_2418">Android-开屏</option>
                                <option value="5899_229">Android-阅读页底部横幅</option>
                                <option value="5899_2419">Android-插屏</option>
                                <option value="5899_2334">Android-章节末原生</option>
                                <option value="5899_2335">Android-阅读完成页原生</option>
                            </optgroup>
                            <optgroup label="IOS">
                                <option value="5899_2421">IOS-开屏</option>
                                <option value="5899_741">IOS-阅读页底部横幅</option>
                                <option value="5899_2420">IOS-插屏</option>
                                <option value="5899_2348">IOS-章节末原生</option>
                                <option value="5899_2349">IOS-阅读完成页原生</option>
                            </optgroup>
                        </select>
                    </li>
                    <li>
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
            <div class="x_content" style="display:block; height: 400px; width: 100%">
                <canvas id="flowChart" style="display:block; height: 400px; width: 100%"></canvas>
            </div>
        </div>
    </div>

    <div class="clearfix"></div>
    <div class="col-md-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>时段流量分布</h2>
                <ul class="nav navbar-right panel_toolbox">
                    <li style="margin-right: 38px">
                        <select id="time_flow_ad_pos" class="form-control">
                            <option></option>
                            <optgroup label="Android">
                                <option value="5899_2418">Android-开屏</option>
                                <option value="5899_229">Android-阅读页底部横幅</option>
                                <option value="5899_2419">Android-插屏</option>
                                <option value="5899_2334">Android-章节末原生</option>
                                <option value="5899_2335">Android-阅读完成页原生</option>
                            </optgroup>
                            <optgroup label="IOS">
                                <option value="5899_2421">IOS-开屏</option>
                                <option value="5899_741">IOS-阅读页底部横幅</option>
                                <option value="5899_2420">IOS-插屏</option>
                                <option value="5899_2348">IOS-章节末原生</option>
                                <option value="5899_2349">IOS-阅读完成页原生</option>
                            </optgroup>
                        </select>
                    </li>
                    <li style="margin-right: 38px">
                        <select id="time_flow_ad_brand" class="form-control">
                            <option></option>
                            <option value="1">宜搜</option>
                            <option value="2">百度</option>
                            <option value="4">广点通</option>
                            <option value="16">聚效</option>
                            <option value="17">百度原生横幅</option>
                            <option value="21">广点通原生横幅</option>
                            <option value="22">DSP原生</option>
                        </select>
                    </li>
                    <li>
                        <div class="title_right">
                            <div style="width: 70px" class="pull-right"></div>
                            <%--<button id="query" type="button" class="btn btn-primary pull-right btn-xs">查询</button>--%>
                            <div class="col-md-11 has-feedback">
                                <input type="text" class="form-control has-feedback-left" name="dayForTime" placeholder="查询日期" aria-describedby="timeInputSuccess2Status4">
                                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                <span id="timeInputSuccess2Status4" class="sr-only">(success)</span>
                            </div>
                        </div>
                    </li>
                    <li>
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
            <div class="x_content" style="display:block; height: 400px; width: 100%">
                <canvas id="timeFlowChart" style="display:block; height: 400px; width: 100%"></canvas>
            </div>
        </div>
    </div>

    <div class="clearfix"></div>
    <div class="col-md-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>广告位调度详情</h2>
                <ul class="nav navbar-right panel_toolbox">
                    <li>
                        <div style="margin-right: 10px; padding-top: 5px">
                            <label style="padding-top: 3px">系统类型：</label>
                            <input type="radio" name="osType" value="1" checked>Android
                            <input type="radio" name="osType" value="2">IOS
                        </div>
                    </li>

                    <li>
                        <div class="title_right">
                            <div style="width: 70px" class="pull-right"></div>
                            <%--<button id="query" type="button" class="btn btn-primary pull-right btn-xs">查询</button>--%>
                            <div class="col-md-11 has-feedback">
                                <input type="text" class="form-control has-feedback-left" name="day" placeholder="查询日期" aria-describedby="inputSuccess2Status4">
                                <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                <span id="inputSuccess2Status4" class="sr-only">(success)</span>
                            </div>
                        </div>
                    </li>
                    <li>
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
            <div class="x_content" style="height: 500px">
                <div class="row">
                    <div id="ad_pos" class="col-md-3">
                        <div class="list-group" style="margin-top: 7px">
                            <c:forEach var="key" items="${keys}">
                                <a href="javascript://" class="list-group-item">${key}</a>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div id="invokeTotalContainer" style="display: none;" class="col-md-12">
                            <span>调度总数：</span><span id="invokeTotal"></span>
                        </div>
                        <div id="pos_detail"></div>
                        <div class="clearfix"></div>
                        <div id="packages">
                        </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<c:url value='/res/vendors/jquery/jquery-2.2.3.min.js'/>"></script>
<script src="<c:url value='/res/vendors/bootstrap/js/bootstrap.min.js'/>"></script>
<script src="<c:url value='/res/vendors/bootstrap-daterangepicker/moment.min.js'/>"></script>
<script src="<c:url value='/res/vendors/bootstrap-daterangepicker/daterangepicker.js'/>"></script>
<script src="<c:url value='/res/vendors/gentelella/js/custom.min.js'/>"></script>
<script src="<c:url value='/res/vendors/select2-4.0.3/js/select2.min.js'/>"></script>
<script src="<c:url value='/res/vendors/chart/Chart-2.2.2.min.js'/>"></script>
<script src="<c:url value='/res/vendors/icheck-1.x/icheck.min.js'/>"></script>

<script src="<c:url value='/res/vendors/underscore-1.8.3/underscore-min.js'/>"></script>
<script>
    $(function() {


        var url = "<c:url value='/stat/query'/>";


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //处理dau
        var dauCreateChart = function (response) {

            var dirtyDataForFlow = [{
                label: 'Android',
                fill: false,
                borderColor: "rgba(3, 88, 106, 0.70)",
                pointBorderColor: "rgba(3, 88, 106, 0.70)",
                pointBackgroundColor: "rgba(3, 88, 106, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["1"]
            },{
                label: 'IOS',
                fill: false,
                borderColor: "rgba(211,5,248, 0.70)",
                pointBorderColor: "rgba(211,5,248, 0.70)",
                pointBackgroundColor: "rgba(211,5,248, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["2"]
            }];


            var dataForDauFlow = {
                labels : response["labels"],
                datasets : []
            };

            //过滤无效数据集
            $.each(dirtyDataForFlow, function (i, n) {
                if (!_.isUndefined(n.data)) {
                    dataForDauFlow.datasets.push(n)
                }
            });

            Chart.defaults.global.maintainAspectRatio = false;
            var ctx = $("#dauChart").get(0).getContext("2d");
            return new Chart(ctx,{
                type: 'line',
                data: dataForDauFlow,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            });
        };

        var dauFlowChart = undefined;
        $.get(url + "?action=dau", function(response){
            if (!_.isUndefined(dauFlowChart)) {
                dauFlowChart.destroy();
            }
            dauFlowChart = dauCreateChart(response);
        });

        $("#dauReloadBtn").click(function () {
            $.get(url + "?action=dau", function(response){
                if (!_.isUndefined(dauFlowChart)) {
                    dauFlowChart.destroy();
                }
                dauFlowChart = dauCreateChart(response);
            });
        });



        /////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //日期选择控件处理
        var $datePicker = $('input[name="day"]').daterangepicker({
                    singleDatePicker: true,
                    showDropdowns: false,
                    locale: {
                        format: 'YYYY-MM-DD',
                        daysOfWeek: [
                            '周日','周一','周二','周三','周四','周五','周六'
                        ],
                        monthNames: [
                            '一月','二月','三月','四月','五月','六月', '七月','八月','九月','十月','十一月','十二月'
                        ]
                    }
                }
        );

        var createChart = function (response, type) {

            var dirtyData = [{
                label: '总调度',
                fill: false,
                borderColor: "rgba(248, 5, 16, 0.7)",
                pointBorderColor: "rgba(248, 5, 16, 0.7)",
                pointBackgroundColor: "rgba(248, 5, 16, 0.7)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(220,220,220,1)",
                pointBorderWidth: 1,
                data : response["0:1"]
            },{
                label: '自有',
                fill: false,
                borderColor: "rgba(3, 88, 106, 0.70)",
                pointBorderColor: "rgba(3, 88, 106, 0.70)",
                pointBackgroundColor: "rgba(3, 88, 106, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["1:" + type]
            },{
                label: '百度',
                fill: false,
                borderColor: "rgba(211,5,248, 0.70)",
                pointBorderColor: "rgba(211,5,248, 0.70)",
                pointBackgroundColor: "rgba(211,5,248, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["2:" + type]
            },{
                label: '百度原生横幅',
                fill: false,
                borderColor: "rgba(28,231,38, 0.70)",
                pointBorderColor: "rgba(28,231,38, 0.70)",
                pointBackgroundColor: "rgba(28,231,38, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["17:" + type]
            },{
                label: '广点通',
                fill: false,
                borderColor: "rgba(5, 85, 248, 0.7)",
                pointBorderColor: "rgba(5, 85, 248, 0.7)",
                pointBackgroundColor: "rgba(5, 85, 248, 0.7)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["4:" + type]
            },{
                label: '聚效',
                fill: false,
                borderColor: "rgba(235, 227, 8, 0.7)",
                pointBorderColor: "rgba(235, 227, 8, 0.7)",
                pointBackgroundColor: "rgba(235, 227, 8, 0.7)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["16:" + type]
            }];

            var data = {
                labels : response["labels"],
                datasets : []
            };
            //过滤无效数据集
            $.each(dirtyData, function (i, n) {
                if (!_.isUndefined(n.data)) {
                    data.datasets.push(n)
                }
            });

            Chart.defaults.global.maintainAspectRatio = false;
            var ctx = $("#flowChart").get(0).getContext("2d");
            return new Chart(ctx,{
                type: 'line',
                data: data,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            });
        };

        ///////////////////////////////////////////////////
        var eventDataCache = undefined;
        var eventFlowChart = undefined;
        //事件监控类型
        var $eventTypeRedio = $('input[name="eventType"]').iCheck({
            radioClass: 'iradio_minimal-grey'
        }).on("ifChanged", function () {
            if ($(this).is(":checked")) {
                if (_.isUndefined(eventDataCache)) {
                    return;
                }
                if (!_.isUndefined(eventFlowChart)) {
                    eventFlowChart.destroy();
                }
                eventFlowChart = createChart(eventDataCache, $(this).val());
            }
        });

        //下拉选择框
        var $flowAdPosSelect2 = $('#flow_ad_pos').select2({
            placeholder: "请选择广告位",
            width: 200
        });

        //图表颜色
        $flowAdPosSelect2.on("select2:select", function () {
            var adPosition = $flowAdPosSelect2.val();
            $.get(url + "?action=flow&pos=" + adPosition, function(response){
                eventDataCache = response;
                var eventTypeValue = $eventTypeRedio.filter(":checked").val();
                if (!_.isUndefined(eventFlowChart)) {
                    eventFlowChart.destroy();
                }
                eventFlowChart = createChart(eventDataCache, eventTypeValue);
            });
        });

        /////////////////////////////////////////////////////////////////////////////////////////////////////////
        //时段流量分布
        var timeFlowChart = undefined;

        var createTimeFlowChart = function (response) {

            var dirtyDataForFlow = [{
                label: '调度',
                fill: false,
                borderColor: "rgba(248, 5, 16, 0.7)",
                pointBorderColor: "rgba(248, 5, 16, 0.7)",
                pointBackgroundColor: "rgba(248, 5, 16, 0.7)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(220,220,220,1)",
                pointBorderWidth: 1,
                data : response["2"]
            },{
                label: '展现',
                fill: false,
                borderColor: "rgba(3, 88, 106, 0.70)",
                pointBorderColor: "rgba(3, 88, 106, 0.70)",
                pointBackgroundColor: "rgba(3, 88, 106, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["3"]
            },{
                label: '点击',
                fill: false,
                borderColor: "rgba(211,5,248, 0.70)",
                pointBorderColor: "rgba(211,5,248, 0.70)",
                pointBackgroundColor: "rgba(211,5,248, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["4"]
            },{
                label: '失败',
                fill: false,
                borderColor: "rgba(28,231,38, 0.70)",
                pointBorderColor: "rgba(28,231,38, 0.70)",
                pointBackgroundColor: "rgba(28,231,38, 0.70)",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(151,187,205,1)",
                pointBorderWidth: 1,
                data : response["5"]
            }];

            var dataForTimeFlow = {
                labels : response["labels"],
                datasets : []
            };
            //过滤无效数据集
            $.each(dirtyDataForFlow, function (i, n) {
                if (!_.isUndefined(n.data)) {
                    dataForTimeFlow.datasets.push(n)
                }
            });

            Chart.defaults.global.maintainAspectRatio = false;
            var ctx = $("#timeFlowChart").get(0).getContext("2d");
            return new Chart(ctx,{
                type: 'line',
                data: dataForTimeFlow,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            });
        };

        var adPositionForTimeFlow = "";
        var adBrandForTimeFlow = "";

        //日期选择控件处理
        var $datePickerForTimeFlow = $('input[name="dayForTime"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: false,
                locale: {
                    format: 'YYYY-MM-DD',
                    daysOfWeek: [
                        '周日','周一','周二','周三','周四','周五','周六'
                    ],
                    monthNames: [
                        '一月','二月','三月','四月','五月','六月', '七月','八月','九月','十月','十一月','十二月'
                    ]
                }
            }
        );

        $datePickerForTimeFlow.on("hide.daterangepicker", function () {

            if ("" === adPositionForTimeFlow) {
                alert("请选择具体广告位！");
                return;
            }

            if ("" === $timeFlowAdBrandSelect2) {
                alert("请选择广告商！");
                return;
            }

            var currentDay = $datePickerForTimeFlow.val();

            $.get(url + "?action=time&pos=" + adPositionForTimeFlow + "&day=" + currentDay + "&brd=" +adBrandForTimeFlow, function(response){
                if (!_.isUndefined(timeFlowChart)) {
                    timeFlowChart.destroy();
                }
                timeFlowChart = createTimeFlowChart(response);
            });
        });

        //下拉选择框
        var $timeFlowAdBrandSelect2 = $('#time_flow_ad_brand').select2({
            placeholder: "请选择广告商",
            width: 160
        });
        $timeFlowAdBrandSelect2.on("select2:select", function () {
            adBrandForTimeFlow = $timeFlowAdBrandSelect2.val();

            if ("" === adPositionForTimeFlow) {
                alert("请选择具体广告位！");
                return;
            }

            var currentDay = $datePickerForTimeFlow.val();

            $.get(url + "?action=time&pos=" + adPositionForTimeFlow + "&day=" + currentDay + "&brd=" +adBrandForTimeFlow , function(response){
                if (!_.isUndefined(timeFlowChart)) {
                    timeFlowChart.destroy();
                }
                timeFlowChart = createTimeFlowChart(response);
            });
        });

        //下拉选择框
        var $timeFlowAdPosSelect2 = $('#time_flow_ad_pos').select2({
            placeholder: "请选择广告位",
            width: 200
        });
        $timeFlowAdPosSelect2.on("select2:select", function () {
            adPositionForTimeFlow = $timeFlowAdPosSelect2.val();

            if ("" === adBrandForTimeFlow) {
                alert("请选择广告商！");
                return;
            }

            var currentDay = $datePickerForTimeFlow.val();

            $.get(url + "?action=time&pos=" + adPositionForTimeFlow + "&day=" + currentDay + "&brd=" + adBrandForTimeFlow , function(response){
                if (!_.isUndefined(timeFlowChart)) {
                    timeFlowChart.destroy();
                }
                timeFlowChart = createTimeFlowChart(response);
            });
        });









        /////////////////////////////////////////////////////////////////////////////////////////////////////////
        //广告位详情
        var adPositionKeyTemplate = '<a href="javascript://" class="list-group-item">{{adPositionKey}}</a>';

        var platformTemplate = '<div id="platform" class="profile_details" style="float: left"><div class="well profile_view"><div class="col-sm-12"><h4 class="brief"><i>{{name}}</i></h4> <div><span class="title">调度数：</span><span>{{switch}}</span>，<span class="title">占比：</span><span>{{weight}}</span></div> <div><span class="title">接收数：</span><span>{{receive}}</span></div> <div><span class="title">展现数：</span><span>{{show}}</span></div> <div><span class="title">点击数：</span><span>{{click}}</span></div> <div><span class="title">失败数：</span><span>{{failure}}</span></div></div> </div> </div> </div>';

        var $adPositionKeyGroup = $("#ad_pos .list-group");

        var $adPositionDetail = $("#pos_detail");
        var $invokeTotal = $("#invokeTotal");
        var $invokeTotalContainer = $("#invokeTotalContainer");

        var $packages = $("#packages");

        //事件监控类型
        var $osTypeRedio = $('input[name="osType"]').iCheck({
            radioClass: 'iradio_minimal-grey'
        }).on("ifChanged", function () {
            if ($(this).is(":checked")) {
                //清空历史数据
                $invokeTotal.text("");
                $adPositionDetail.children().remove();
                $invokeTotalContainer.hide();

                var currentDay = $datePicker.val();
                var osTypeValue = $osTypeRedio.filter(":checked").val();

                //获取广告位列表
                $.get(url + "?action=list&day=" + currentDay + "&os=" + osTypeValue, function(response){
                    $adPositionKeyGroup.children().remove();
                    $.each(response, function(i, n){
                        $adPositionKeyGroup.append(adPositionKeyTemplate.replace("{{adPositionKey}}", n))
                    });
                });
            }
        });

        $datePicker.on("hide.daterangepicker", function () {
            //清空历史数据
            $invokeTotal.text("");
            $adPositionDetail.children().remove();
            $invokeTotalContainer.hide();

            var currentDay = $datePicker.val();
            var osTypeValue = $osTypeRedio.filter(":checked").val();

            //获取广告位列表
            $.get(url + "?action=list&day=" + currentDay + "&os=" + osTypeValue, function(response){
                $adPositionKeyGroup.children().remove();
                $.each(response, function(i, n){
                    $adPositionKeyGroup.append(adPositionKeyTemplate.replace("{{adPositionKey}}", n))
                });
            });
        });


        String.prototype.startWith = function(str){
            return this.indexOf(str) == 0;
        };

        String.prototype.contain = function (str) {
            return this.indexOf(str) >= 0;
        };

        function formatNum(num){
            if(typeof num !=="number")return false;//判断是否是数字
            num=num.toString();//字符化
            var s=num.match(/e\+(\d+)$/),ext=0;;
            num=num.replace(/e.+$/,'');
            if(s)ext=Number(s[1]);

            //分割小数点两边
            var tA=num.split('.');
            if(tA.length>=2&&ext){//有小数点则分割开来处理(小数点后面可能还跟有科学记数法表示)
                if(tA.length>ext){
                    tA[0]+=tA[1].slice(0,ext-1);
                    tA[1]=tA[1].slice(ext-1,tA[1].length-1);
                }else{
                    tA[0]+=(tA[1]+"0".repeat(ext-tA.length));
                    tA[1]='';
                }
            }

            tA[0]=tA[0].split('');//拆字符
            for(var i=tA[0].length;(i-=3)>0;){//插逗号
                tA[0].splice(i,0,',');
            }
            return tA[0].join('')+(tA[1]?'.'+tA[1]:'');//连起来
        }

        function getPercent(num, total) {
            num = parseFloat(num);
            total = parseFloat(total);
            if (isNaN(num) || isNaN(total)) {
                return "-";
            }
            return total <= 0 ? "0%" : (Math.round(num / total * 10000) / 100.00 + "%");
        }

        //广告位详情
        $('#ad_pos .list-group').on("click", "a", function () {
            $invokeTotalContainer.show();
//            $packages.show();
            $('#ad_pos .list-group a').removeClass("active");
            $(this).addClass("active");

            var osTypeValue = $osTypeRedio.filter(":checked").val();

            var currentDay = $datePicker.val();
            //具体项查询
            $.get(url + "?action=detail&pos=" + $(this).text() + "&day=" + currentDay + "&os=" + osTypeValue, function(response){

                  $.each(response, function(key, value){


                      if (key === "switch") {
                          $adPositionDetail.children().remove();
                          //设置总数
                          var total = parseInt(value["0:未知"]["1"]);
                          $invokeTotal.text(formatNum(total));

                          $.each(value, function (key, value) {
                              if (!key.startWith("0:未知")) {
                                  $adPositionDetail.append(platformTemplate.replace("{{name}}", key.substring(key.indexOf(":") + 1))
                                          .replace("{{switch}}", _.isUndefined(value["2"]) ? "0" : value["2"])
                                          .replace("{{weight}}", getPercent(_.isUndefined(value["2"]) ? "0" : value["2"], total))
                                          .replace("{{receive}}", _.isUndefined(value["11"]) ? "0" : value["11"])
                                          .replace("{{show}}", _.isUndefined(value["3"]) ? "0" : value["3"])
                                          .replace("{{click}}", _.isUndefined(value["4"]) ? "0" : value["4"])
                                          .replace("{{failure}}", _.isUndefined(value["5"]) ? "0" : value["5"]));
                              }
                          });
                      } else if (key === "channel") {
                          $packages.children().remove();
                          var switchTotal = response['switch']["0:未知"]["1"];
                          $.each(value, function (key, value) {
                              var start = '<div class="profile_details red" style="float: left"><div class="well profile_view"><div class="col-sm-12">';
                              var end = '</div></div></div>';
                              var title = '<h4 class="brief"><i>' + (key.substring(key.indexOf(":") + 1)) +  '</i></h4>';
                              var content = "";
                              var hasProperty = false;
                              $.each(value, function (key, value) {
                                  content += '<div><span class="title">' + key + '</span><span>调用数：' + value + '</span>，<span class="title">占比：</span><span>' + getPercent(value, switchTotal) + '</span></div>';
                                  hasProperty = true;
                              });
                              if (hasProperty === true) {
                                  $packages.append($(start + title + content + end));
                              }
                          });
                      }
                  });





            });
        });
    });
</script>
</body>
</html>
