/**
 * Android 积分墙JavaScript脚本
 * User: 谢佩佩
 * Date: 14-5-21
 * Time: 下午8:28
 */

    //定义命名空间
    var easouwall = window.easouwall || {};

    //已经加载的广告缓存
    easouwall.cache0 = [];
    easouwall.cache1 = [];

    easouwall.tagNameType = 0;

    easouwall.type = "offerlist";

    //检测是否是模拟器
    easouwall.isEmulator = false;

    //虚拟货币名称
    easouwall.currencyName = "金币";
    
    easouwall.serverSet ={"sid":"fb10cf5a-850d-40a0-8265-7ece96c683c2","u_w":"720","u_ds":"2.0","nett":"3","mac":"34:23:BA:B8:19:F1","ver":"2.1.0","muid":"4194","av":"1.0","ct":"1","mmid":"90","u_h":"1280","an":"宜搜积分墙样例","ua":"Mozilla\/5.0 (Linux; U; Android 4.3; zh-cn; GT-I9300 Build\/JSS15J) AppleWebKit\/534.30 (KHTML, like Gecko) Version\/4.0 Mobile Safari\/534.30","sim":"","pn":"com.easou.ecom.offerwall.demo","sdk":"esow","mid":"357070056936000"};

    /**
     * 积分墙广告对应的9种状态，激活状态：激活、未激活；下载状态：未下载、下载未安装、已安装
     */
    easouwall.status = {
        ACTIVATE_DOWNLOADED : "ACTIVATE_DOWNLOADED",
        ACTIVATE_UNDOWNLOADED : "ACTIVATE_UNDOWNLOADED",
        ACTIVATE_INSTALLED : "ACTIVATE_INSTALLED",
        ACTIVATE_DOWNLOADING : "ACTIVATE_DOWNLOADING",
        UNACTIVATE_DOWNLOADED : "UNACTIVATE_DOWNLOADED",
        UNACTIVATE_UNDOWNLOADED : "UNACTIVATE_UNDOWNLOADED",
        UNACTIVATE_INSTALLED : "UNACTIVATE_INSTALLED",
        UNACTIVATE_DOWNLOADING : "UNACTIVATE_DOWNLOADING",
        ACTIVATE_TRIAL : "ACTIVATE_TRIAL"
    };

    /**
     * 关闭积分墙
     */
    easouwall.close = function() {
        window.esofw.backPressed();
    };

    /**
     * 初始化
     */
    easouwall.initWall = function () {
		easouwall.isEmulator = false;
        //发送pv request
//        easouwall.pvCall();
        //初始化工具条
        easouwall.initToolBar();
        //加载配置信息
        easouwall.loadConfig();
        //加载第一屏广告
        easouwall.loadAd("offerlist");
        //设置积分
        easouwall.initPoints();
    };


    /**
     * 初始化金币数
     */
    easouwall.initPoints = function() {
        $("#points").html($.parseJSON(window.esofw.getPoints()).points);
    };

    /**
     * 发送pv call
     */
    easouwall.pvCall = function() {
        var publisherId = easouwall.getPublisherId();
        var tmpId = publisherId.split("_");
        var muid = tmpId[0];
        var mmid = tmpId[1];
        var url = "http://pvcall.easou.com/uishow.png?os=1&mt=12&t="  + (new Date().getTime()) + "&muid=" + muid + "&mmid=" + mmid;
        //发送pv call日志
        window.esofw.sendLog(url);
    };

    /**
     *获取开发者id
     * @returns {string}
     */
    easouwall.getPublisherId = function() {
        return $.parseJSON(window.esofw.getPublisherId()).publisherId;
    };


    /**
     * 根据请求url初始化工具条
     */
    easouwall.initToolBar = function() {
        var noback = easouwall.getQueryString("noback");
        //隐藏关闭按钮
        if (noback == "true") {
            $(".right").hide();
        }
        var notoolbar = easouwall.getQueryString("notoolbar");
        //隐藏工具栏
        if (notoolbar == "true") {
            $("#top").hide();
            $("#limit").hide();
            $("#container").css("margin-top", "-7px");
        }
    };

    /**
     * 获取url查询字符串
     * @returns {*}
     */
    easouwall.getQueryString = function(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) {
            return r[2];
        }
        return null;
    };

    /**
     * 滑动加载更多广告
     */
    easouwall.moreAd = function() {
        var excludeIdArray = [];
        if(easouwall.type=="offerlist"){
        	easouwall.cache0.forEach(function(item, index, array){
                excludeIdArray.push(item.id);
            });
        }else if(easouwall.type=="appofferlist"){
        	easouwall.cache1.forEach(function(item, index, array){
                excludeIdArray.push(item.id);
            });
        }
        
        var excludeIdString = excludeIdArray.join(",");
        var data = easouwall.serverSet;
        data.os = "1";
        data.ct = "1";
        data.pclist = excludeIdString;
        data.type = easouwall.type;
        //显示加载进度
        $("#loading").show();
        $.ajax({
            type : "GET",
            url : "../offerad",
            data : data,
            timeout : 20000,
            success : function(data) {
                var $list = $("#list");
                var ads =  data.ad;
                for (var i = 0; i < ads.length; i++) {
                    var ad = ads[i];
                    var adString = easouwall.jsonToString(ad);
                    //检测广告状态，如正在下载、已经下载、已经激活等
//                    var adStatus = $.parseJSON(window.esofw.checkApkStatus(adString));
//                    ad.status = adStatus.status;

                    //模拟器特殊处理
                    if (easouwall.isEmulator) {
                        ad.po = 0;
                        ad.show_po = 0;
                        ad.status = ad.status.replace("UNACTIVATE_", "ACTIVATE_");
                    }
                    $list.append(easouwall.generateAdHtml(ad));
                    //将已经加载的广告放入缓存
                    if(easouwall.type=="offerlist"){
                    	easouwall.cache0.push(ad);
                    }else if(easouwall.type=="appofferlist"){
                    	easouwall.cache1.push(ad);
                    }
                }
                $("#loading").hide();
            },
            error: function(xhr, type){

            }
        });
    };

    /**
     * 加载积分墙广告
     */
    easouwall.loadAd = function(_type) {
        var serverSettings = easouwall.serverSet;
    	serverSettings.type = _type;
        //标识Android系统
        serverSettings.os = "1";
        $.ajax({
            type : "GET",
            url : "../offerad",
            data : serverSettings,
            timeout : 20000,
            success : function(data) {
                console.info("loadAd success");
                var $list = $("#list");
                var ads =  data.ad;
                for (var i = 0; i < ads.length; i++) {
                    var ad = ads[i];
                    var adString = easouwall.jsonToString(ad);
                    //检测广告状态，如正在下载、已经下载、已经激活等
//                    var adStatus = $.parseJSON(window.esofw.checkApkStatus(adString));
//                    ad.status = adStatus.status;
                    //检测是否是模拟器
                    if (easouwall.isEmulator) {
                        ad.po = 0;
                        ad.show_po = 0;
                        ad.status = ad.status.replace("UNACTIVATE_", "ACTIVATE_");
                    }
                    $list.append(easouwall.generateAdHtml(ad));
                    //将已经加载的广告放入缓存
                    if(_type=="offerlist"){
                    	easouwall.cache0.push(ad);
                    }else if(_type=="appofferlist"){
                    	easouwall.cache1.push(ad);
                    }
                }
                $("#loading").hide();
                window.esofw.onLoaded();
            },
            error: function(xhr, errorType){

            }
        });
    };

    /**
     * 加载配置信息
     */
    easouwall.loadConfig = function() {
        $.ajax({
            type : "GET",
            url : "../offerconfig",
            data : easouwall.serverSet,
            timeout : 10000,
            success : function(data) {
                //设置虚拟货币名称
                window.esofw.setCurrencyName(data.name);
                easouwall.currencyName = data.name;
                $("#vname").html(data.name);
                //控制是否显示剩余积分
                if (!Boolean(data.wallpointswitch)) {
                    $("#vpoints").css("visibility", "hidden");
                }
            },
            error : function(xhr, errorType) {
            }
        });
    };

    /**
     * 返回到主页
     */
    easouwall.returnMainPage = function() {
        $(".wrap").show();
        $("#detail").children().remove();
        $("#detail").hide();
    };

    /**
     * 从缓存中获取一个特定广告
     * @param id     广告标识
     * @returns {*} 广告对象
     */
    easouwall.getAd = function(id) {
    	var cache;
    	if(easouwall.type=="offerlist"){
    		cache = easouwall.cache0;
    	}else if(easouwall.type=="appofferlist"){
    		cache = easouwall.cache1;
    	}
        for (var idx in cache) {
            var ad = cache[idx];
            if (ad.id == id) {
                return ad;
            }
        }
        return null;
    };

    /**
     * 处理广告动作，如试用、注册等
     * @param id 广告标识
     */
    easouwall.handleAction = function(id) {
        window.esofw.onTaskStart(easouwall.jsonToString(easouwall.getAd(id)));
    };

    /**
     * 下载apk包
     * @param id
     */
    easouwall.handleDownload = function(id) {
        var ad = easouwall.getAd(id);
        var clonedAd = {};
        $.extend(clonedAd, ad);
        clonedAd.status = easouwall.status.UNACTIVATE_UNDOWNLOADED;
        window.esofw.onTaskStart(easouwall.jsonToString(clonedAd));
    };

    /**
     * 显示广告细节
     * @param item
     */
    easouwall.showAdDetail = function(item) {
        var ad = easouwall.getAd(item.id);
        //发送广告点击日志
//        window.esofw.sendLog(ad.clog);

        //拼接广告详情页
        var html = '<div id="container">';
                html += '<header>';
                    html += '<div class="clearfix">';
                        html += '<h1>';
                            html += '<div class="back">';
                                html += '<a onclick="easouwall.returnMainPage()"><img src="./images/back.png" alt=""></a>';
                            html += '</div>';
                            html += '<div class="center"><span style=\'vertical-align:middle;\'>免费赚取' + easouwall.currencyName + '</span><img style="width:60px;vertical-align:middle;" src="images/logo.png"/></div>';
                        html += '</h1>';
                html += '</header>';
                html += '<div id="main" style="margin-top: 45px">';
                    html += '<section>';
                        html += '<div class="sw-info">';
                            html += '<div class="fun-btn">';
                                var step = parseInt(ad.step);
                                var po = parseInt(ad.po);
                                if (step == 1) {
                                    //已经安装
                                    if ((ad.status == easouwall.status.ACTIVATE_INSTALLED) || (ad.status == easouwall.status.UNACTIVATE_INSTALLED)) {
                                        html += '<p class="jifen">已安装</p>';
                                    } else {
                                        html += '<p class="jifen">送<span class="color">' + ad.po + '</span>' + easouwall.currencyName +'</p>';
                                    }
                                } else if (step == 2) {
                                    if (po > 0) {
                                        html += '<p class="jifen">送<span class="color">' + ad.po + '</span>' + easouwall.currencyName +'</p>';
                                    } else {
                                        html += '<p class="jifen">已安装</p>';
                                    }
                                } else if (step == 3) {
                                    html += '<p class="jifen">已安装</p>';
                                }
                                html += '<p><a href="#" onclick="easouwall.handleAction(' + ad.id + ')" title="" id="down1" class="load-btn">' + ad.btnName + '</a></p>';
                            html += '</div>';
                            html += '<div class="sw-img">';
                                html += '<img src="' + ad.logo + '" width="60px" style="border-radius: 5px">';
                            html += '</div>';
                            html += '<div class="sw-text">';
                                html += '<p class="tle">' + ad.name + '</p>';
                                html += '<p class="banben"></p>';
                                html += '<p class="daxiao">大小&nbsp;&nbsp;' + (Math.round(ad.pksz/10)) / 100 + 'M</p>';
                            html += '</div>';
                            //任务已经完成，不再显示积分获取步骤
                            if (parseInt(ad.step) != 3) {
                                html += '<p id="stepInfo' + ad.id + '" class="slogan" style="height: 100%; font-size: 13px; font-weight: lighter; padding: 2px;"><div style="border:1px dashed #19b9ff;text-align: left;padding: 5px;margin-top:15px;color: #fd7741;">' + ad.step_info + '<br/>&nbsp;<span style="color:#BA8300">在未完成以上所有步骤前切勿卸载</span></div></p>';
                            } else {
                                html += '<div style="height: 20px"></div>';
                            }

                        html += '</div>';
                        html += '<div id="progress' + ad.id + '" class="progress-bar blue stripes" style="display:none"><span id="progressData' + ad.id + '"></span></div>';

                        html += '<div class="sw-des">';
                            html += '<p>' + ad.desc2 + '<br></p>';
                            html += '<p>';
                                html += '<img src="' + ad.image1 + '" width="140px"/>';
                                html += '<img src="' + ad.image2 + '" width="140px"/>';
                            html += '</p>';
                        html += '</div>';
                        html += '<div class="fun_btn black">';
                            html += '<a href="#" onclick="easouwall.handleDownload(' + ad.id + ')"  title="">立即下载安装&gt;&gt;</a>';
                        html += '</div>';
                        html += '<div class="clearfix bfont">';
                            html += ad.company;
                        html += '</div>';
                    html += '</section>';
                html += '</div>';
            html += '</div>';
        //隐藏主页
        $(".wrap").hide();

        //显示详情页
        $("#detail").show();
        $("#detail").html(html);
        //通知明显有没有打开
        window.esofw.setDetaiShown(true);
    };

    /**
     * 产生广告Html代码片段
     * @param ad 广告对象
     */
    easouwall.generateAdHtml = function(ad) {
        var html = '<li>';
             html += '<div class="offer" name="0">';
                html += '<a href="#" onclick="easouwall.showAdDetail(this)" id="' + ad.id +'">';
                    html += '<div class="offer_in">';
                        html += '<span class="ico">';
                            html += '<img src="' + ad.logo + '" width="48px">';
                        html += '</span>';
                        html += '<div class="text">';
                            html += '<div class="title">' +  ad.name + '<span>' + (Math.round(ad.pksz/10)) / 100 + 'M</span><span class="fenlei">' + ad.catgory + '</span></div>';
                            html += '<div class="adwords">' + ad.desc + '</div>';
                            html += '<div class="line">';
                            var step = parseInt(ad.step);
                            var po = parseInt(ad.po);
                            //将要激活
                            if (step == 1) {
                                //已经安装
                                if ((ad.status == easouwall.status.ACTIVATE_INSTALLED) || (ad.status == easouwall.status.UNACTIVATE_INSTALLED)) {
                                    html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                                    html += '<span id="status_' + ad.id + '">已安装</span>';
                                } else {
                                    html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                                    html += '<span id="status_' + ad.id + '">送<span class="color">' + ad.show_po + '</span>' + easouwall.currencyName + '</span>';
                                }
                            } else if (step == 2) { //多步骤返积分，执行到第二步
                                if (po > 0) { //第二步在有效时间范围内，可以执行第二步
                                    ad.btnName = "签到"; //强制改为"签到"
                                    html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                                    html += '<span id="status_' + ad.id + '">送<span class="color">' + ad.show_po + '</span>' + easouwall.currencyName + '</span>';
                                } else { //多步骤返积分，有效时间未到，执行第二步无效
                                    html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                                    html += '<span id="status_' + ad.id + '">已安装</span>';
                                }
                            } else if (step == 3) { //任务已经完成
                                html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                                html += '<span id="status_' + ad.id + '">已安装</span>';
                            }
                            html += '</div>';
                            html += '<div class="cb"></div>';
                        html += '</div>';
                    html += '</div>';
                html += '</a>';
             html += '</div>';
            html += '</li>';
        return html;
    };

    /**
     * 将json对象转换为字符串
     * @param jsonObject   要转换的json对象
     * @returns {string}
     */
    easouwall.jsonToString = function(jsonObject) {
        if(jsonObject) {
            var result = "{";
            for (var item in jsonObject) {
                result += "\"" + item + "\": ";
                if (typeof jsonObject[item] == 'string') {
                    result += ("\"" + jsonObject[item] + "\", ");
                } else if (typeof jsonObject[item] == 'number') {
                    result += (jsonObject[item] + ", ");
                } else {
                    result += easouwall.jsonToString(jsonObject[item]);
                }
            }
            var index = result.lastIndexOf(", ");
            if (index != -1) {
                result = result.substring(0, index);
            }
            result += "}";
            return result;
        } else {
            return "undefined";
        }
    };

//////////////////////////////////////////////////////老版本兼容代码////////////////////////////////////////////////////
//定义命名空间
var Easou = {};
Easou.util = {};
Easou.offerManager = {};

/**
 * 通知开始下载
 * SDK-JS交互接口，不可混淆
 * @param adid
 */
Easou.offerManager.startToDownload = function(adid) {
        //获取正在下载的广告信息
        var ad = easouwall.getAd(adid);
        //发送下载日志
        window.esofw.sendLog(ad.dlog);
        //更改广告状态
        if (ad.status.indexOf("ACTIVATE_") == 0) {
            ad.status = easouwall.status.ACTIVATE_DOWNLOADING;
        } else {
            ad.status = easouwall.status.UNACTIVATE_DOWNLOADING;
        }
        //初始化下载进度
        var $progress = $("#progress" + adid);
        if ($progress) {
            $progress.show();
        }
};

/**
 * 用于实时显示下载进度
 * SDK-JS交互接口，不可混淆
 * @param adid
 * @param progress
 */
Easou.offerManager.updateProgress = function(adid, progress) {
    var $progressData = $("#progressData" + adid);
    if ($progressData) {
        $progressData.css("width", progress + "%");
        if (parseInt(progress) > 20) {
            $progressData.html("&nbsp;&nbsp;下载" + progress + "%");
        }
    }
};

/**
 * 通知下载完成
 * SDK-JS交互接口，不可混淆
 * @param adid
 */
Easou.offerManager.downloadFinish = function(adid) {
    //隐藏下载进度
    var $progress = $("#progress" + adid);
    var $progressData = $("#progressData" + adid);
    //进度信息还原
    if ($progressData) {
        $progressData.css("width", "0%");
    }
    //隐藏进度信息
    if ($progress ) {
        $progress.hide();
    }

    var ad = easouwall.getAd(adid);
    //发送下载完成log
    window.esofw.sendLog(ad.endlog);
    if (ad) {
        if (ad.status.indexOf("ACTIVATE_") == 0) {
            ad.status = easouwall.status.ACTIVATE_DOWNLOADED;
        } else {
            ad.status = easouwall.status.UNACTIVATE_DOWNLOADED;
        }
    }

};

/**
 * 通知app激活
 * SDK-JS交互接口，不可混淆
 * @param adid
 */
Easou.offerManager.active =function(adid) {
    var ad = easouwall.getAd(adid);
    if (ad) {
        ad.status = easouwall.status.ACTIVATE_INSTALLED;
        ad.po = 0;
        $("#status_" + adid).children().remove();
        $("#status_" + adid).html("已安装");
        //返回到主页面
        easouwall.returnMainPage();
    }
};

/**
 * 积分发生变化后更新界面上的积分
 * SDK-JS交互接口，不可混淆
 * @param points
 */
Easou.offerManager.updatePoints = function(points) {
    $("#points").html(points);
};

/**
 * app安装完成后回调
 * SDK-JS交互接口，不可混淆
 * @param adid
 */
Easou.offerManager.installFinish = function(adid) {
    console.info("Easou.offerManager.installFinish :" + adid);
    var ad = easouwall.getAd(adid);
    if (ad) {
        if (ad.status.indexOf("ACTIVATE_") == 0) {
            ad.status = easouwall.status.ACTIVATE_INSTALLED;
        } else {
            ad.status = easouwall.status.UNACTIVATE_INSTALLED;
        }
    }
    //返回到主界面
    easouwall.returnMainPage();
    $("#status_" + adid).html("已安装");
};

/**
 * 隐藏明细
 */
Easou.util.hideDetail = function() {
    easouwall.returnMainPage();
    window.esofw.setDetaiShown(false);
};

function nav_click(_this){
	var cache = [];
	var id = $(_this).attr("id");
	var _class = $(_this).attr("class");
	if(_class != 'active'){
		easouwall.type = id;
		if(id=="offerlist"){
			$("#appofferlist").removeClass('active');
		}else if(id=="appofferlist"){
			$("#offerlist").removeClass('active');
		}
		$(_this).addClass('active');
		var $list = $("#list");
		$list.html("");
		if((id=="offerlist" && easouwall.cache0.length == 0) || (id=="appofferlist" && easouwall.cache1.length == 0)){
			$("#loading").show();
			easouwall.loadAd(id);
			return;
		}else if(id=="offerlist"){
			cache = easouwall.cache0;
		}else if(id=="appofferlist"){
			cache = easouwall.cache1;
		}
		for(var i = 0; i < cache.length; i++){
			var ad = cache[i];
	        var adString = easouwall.jsonToString(ad);
	        //检测广告状态，如正在下载、已经下载、已经激活等
//	        var adStatus = $.parseJSON(window.esofw.checkApkStatus(adString));
//	        ad.status = adStatus.status;
	        //检测是否是模拟器
	        if (easouwall.isEmulator) {
	            ad.po = 0;
	            ad.show_po = 0;
	            ad.status = ad.status.replace("UNACTIVATE_", "ACTIVATE_");
	        }
	        $list.append(easouwall.generateAdHtml(ad));
	      
		}
	}
}