/**
 * Created with IntelliJ IDEA.
 * User: XPP
 * Date: 14-5-23
 * Time: 上午10:05
 * To change this template use File | Settings | File Templates.
 */

var easouwall = window.easouwall || {};
//JS和OC交互桥
easouwall.bridge = {};
//广告信息
easouwall.adsCache0 = []; //热门推荐
easouwall.adsCache1 = []; //签到

easouwall.type = "offerlist"; //热门推荐
//是否是模拟器
easouwall.isEmulator = false;
//请求广告参数
easouwall.settings = {};
//虚拟货币名称
easouwall.currencyName = "金币";
/**
 * 积分墙广告对应的9种状态，激活状态：激活、未激活；下载状态：未下载、下载未安装、已安装
 */
easouwall.status = {
    ACTIVATE_DOWNLOADED : "ACTIVATE_DOWNLOADED",
    ACTIVATE_UNDOWNLOADED : "ACTIVATE_UNDOWNLOADED",
    ACTIVATE_INSTALLED : "ACTIVATE_INSTALLED",
    ACTIVATE_DOWNLOADING : "ACTIVATE_DOWNLOADING",
    UNACTIVATE_DOWNLOADED : "UNACTIVATE_DOWNLOADED",
    UNACTIVATE_UNDOWNLOADED : "UNACTIVATE_UNDOWNLOADED",
    UNACTIVATE_INSTALLED : "UNACTIVATE_INSTALLED",
    UNACTIVATE_DOWNLOADING : "UNACTIVATE_DOWNLOADING",
    ACTIVATE_TRIAL : "ACTIVATE_TRIAL"
};
/**
 * 从url解析参数
 * @param name
 * @returns {*}
 */
easouwall.getQueryString = function (name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) {
        return r[2];
    }
    return null;
};
//初始化JS-SDK交互桥
easouwall.initWall = function(){
	easouwall.bridge = window.WebViewJavascriptBridge;
    var bridge = easouwall.bridge;
    bridge.init(function(message, responseCallback) {
        var data = { 'Javascript Responds':'Wee!' };
        responseCallback(data);
    });
//    bridge.registerHandler('testJavascriptHandler', function(data, responseCallback) {
//        alert("testJavascriptHandler");
//        var responseData = { 'Javascript Says':'Right back atcha!' };
//        responseCallback(responseData);
//    });
  //发送pv request
    easouwall.initToolBar();
	easouwall.initAdServerSettings();
	easouwall.initPoints();
};

/**
 * 根据请求url初始化工具条
 */
easouwall.initToolBar = function() {
    var noback = easouwall.getQueryString("noback");
    //隐藏关闭按钮
    if (noback == "true") {
        $(".right").hide();
    }else {
        $(".right").show();
    }
    var notoolbar = easouwall.getQueryString("notoolbar");
    //隐藏工具栏
    if (notoolbar == "true") {
        $("#top").hide();
        $("#limit").hide();
        $("#container").css("margin-top", "-47px");
    }
};

/**
 * 加载配置信息
 */
easouwall.loadConfig = function() {
    $.ajax({
        type : "GET",
        url : "../offerconfig",
        data : easouwall.settings,
        timeout : 10000,
        success : function(data) {
            //设置虚拟货币名称
        	easouwall.setCurrencyName(data.name);
            easouwall.currencyName = data.name;
            $("#vname").html(data.name);
            //控制是否显示剩余积分
            if (!Boolean(data.wallpointswitch)) {
                $("#vpoints").css("visibility", "hidden");
            }
        },
        error : function(xhr, errorType) {
//            $("#loading").hide();
//            $("#error").css("display", "table");
        }
    });
};

/**
 * 加载积分墙广告
 */
easouwall.loadAd = function(_type) {
	easouwall.settings.type = _type;
    $.ajax({
        type : "GET",
        url : "../offerad",
        data : easouwall.settings,
        timeout : 1000,
        success : function(data) {
            console.info("loadAd success");
            var $list = $("#list");
            if(_type == "offerlist") {
                var reachMaxFlag = data.rmf;
                if (reachMaxFlag == 1) { //达到媒体主激活上限
                    $("#limit").show();
                } else {
                    $("#limit").hide();
                }
            } else {
                $("#limit").hide();
            }
            var excludeIdArray = [];
            if(_type=="offerlist"){
            	easouwall.adsCache0.forEach(function(item, index, array){
                    excludeIdArray.push(item.id);
                });
            }else if(_type=="appofferlist"){
            	easouwall.adsCache1.forEach(function(item, index, array){
                    excludeIdArray.push(item.id);
                });
            }
            var excludeIdString = excludeIdArray.join(",");
            var ads =  data.ad;
            if (ads.length > 0) {
            	var tmpArr = [];
            	for (var i = 0; i < ads.length; i++) {
                    var ad = ads[i];
                    tmpArr.push(easouwall.jsonToString(ad));
                }
            	var checkStr = "[" + tmpArr.join(",") + "]";
            	//检测广告状态，如正在下载、已经下载、已经激活等
                easouwall.bridge.callHandler('checkApkStatus', checkStr, function(responseData) {
                	 var adData = eval(responseData);
                	 var el = "";
                     for (var i = 0; i < adData.length; i ++) {
                         var curAd = adData[i];
                         if (easouwall.isEmulator) {//模拟器中全显示为已完成
                             curAd.po = 0;
                             curAd.show_po = 0;
                             curAd.status = curAd.status.replace("UNACTIVATE_", "ACTIVATE_");
                         }
                         if(excludeIdString.indexOf(curAd.id) <= 0){
                        	 //缓存处理过的广告
                             if(_type=="offerlist"){
                            	 easouwall.adsCache0.push(curAd);
                             }else if(_type=="appofferlist"){
                            	 easouwall.adsCache1.push(curAd);
                             }
                             //广告数据解析成html
                             el += easouwall.generateAdHtml(curAd);
                         }
                     }
                     $list.append(el);
                });
            }
            $("#loading").hide();
        },
        error: function(xhr, errorType){

        }
    });
};

/**
 * 初始化金币数
 */
easouwall.initPoints = function() {
	easouwall.bridge.send("getPoints", function(responseData){
		easouwall.updatePoints(responseData);
	    });
};

/**
 * 积分发生变化后更新界面上的积分
 * SDK-JS交互接口，不可混淆
 * @param points
 */
easouwall.updatePoints = function(points) {
	easouwall.points = points;
    $("#points").html(points);
};

/**
 * 滑动加载更多广告
 */
easouwall.moreAd = function() {
	var _type = easouwall.type;
    //显示加载进度
    $("#loading").show();
    var excludeIdArray = [];
    if(_type=="offerlist"){
    	 easouwall.adsCache0.forEach(function(item, index, array){
    	        excludeIdArray.push(item.id);
    	    });
    }else if(_type=="appofferlist"){
    	easouwall.adsCache1.forEach(function(item, index, array){
	        excludeIdArray.push(item.id);
	    });
    }
   
    var excludeIdString = excludeIdArray.join(",");
    var data = easouwall.settings;
    easouwall.settings.type = _type;
    data.pclist = excludeIdString;
    $.ajax({
        type : "GET",
        url : "../offerad",
        data : data,
        timeout : 20000,
        success : function(data) {
            var $list = $("#list");
            if(_type == "offerlist") {
                var reachMaxFlag = data.rmf;
                if (reachMaxFlag == 1) { //达到媒体主激活上限
                    $("#limit").show();
                } else {
                    $("#limit").hide();
                }
            } else {
                $("#limit").hide();
            }
            var ads =  data.ad;
            if (ads.length > 0) {
            	 var tmpArr = [];
            	for (var i = 0; i < ads.length; i++) {
                    var ad = ads[i];
                    tmpArr.push(easouwall.jsonToString(ad));
                }
            	var checkStr = "[" + tmpArr.join(",") + "]";
            	excludeIdArray = [];
                if(_type=="offerlist"){
                	easouwall.adsCache0.forEach(function(item, index, array){
                        excludeIdArray.push(item.id);
                    });
                }else if(_type=="appofferlist"){
                	easouwall.adsCache1.forEach(function(item, index, array){
                        excludeIdArray.push(item.id);
                    });
                }
                excludeIdString = excludeIdArray.join(",");
            	//检测广告状态，如正在下载、已经下载、已经激活等
                easouwall.bridge.callHandler('checkApkStatus', checkStr, function(responseData) {
                	 var adData = eval(responseData);
                	 var el = "";
                     for (var i = 0; i < adData.length; i ++) {
                         var curAd = adData[i];
                         if (easouwall.isEmulator) {//模拟器中全显示为已完成
                             curAd.po = 0;
                             curAd.show_po = 0;
                             curAd.status = curAd.status.replace("UNACTIVATE_", "ACTIVATE_");
                         }
                         if(excludeIdString.indexOf(curAd.id) <= 0){
                        	 //缓存处理过的广告
                             if(_type=="offerlist"){
                            	 easouwall.adsCache0.push(curAd);
                             }else if(_type=="appofferlist"){
                            	 easouwall.adsCache1.push(curAd);
                             }
                             //广告数据解析成html
                             el += easouwall.generateAdHtml(curAd);
                         }
                     }
                     $list.append(el);
                });
            }
            $("#loading").hide();
        },
        error: function(xhr, type){
        	 $("#loading").hide();
        }
    });
};

/**
 * 将json对象转换为字符串
 * @param jsonObject   要转换的json对象
 * @returns {string}
 */
easouwall.jsonToString = function(jsonObject) {
    if(jsonObject) {
        var result = "{";
        for (var item in jsonObject) {
            result += "\"" + item + "\": ";
            if (typeof jsonObject[item] == 'string') {
                result += ("\"" + jsonObject[item] + "\", ");
            } else if (typeof jsonObject[item] == 'number') {
                result += (jsonObject[item] + ", ");
            } else {
                result += easouwall.jsonToString(jsonObject[item]);
            }
        }
        var index = result.lastIndexOf(", ");
        if (index != -1) {
            result = result.substring(0, index);
        }
        result += "}";
        return result;
    } else {
        return "undefined";
    }
};

/**
 * 产生广告Html代码片段
 * @param ad 广告对象
 */
easouwall.generateAdHtml = function(ad) {
	var html = '<li>';
    html += '<div class="offer" name="0">';
       html += '<a href="#" onclick="easouwall.showAdDetail(this)" id="' + ad.id +'">';
           html += '<div class="offer_in">';
               html += '<span class="ico">';
                   html += '<img src="' + ad.logo + '" width="48px">';
               html += '</span>';
               html += '<div class="text">';
                   html += '<div class="title">' +  ad.name + '<span>' + (Math.round(ad.pksz/10)) / 100 + 'M</span><span class="fenlei">' + ad.catgory + '</span></div>';
                   html += '<div class="adwords">' + ad.desc + '</div>';
                   html += '<div class="line">';
                   var step = parseInt(ad.step);
                   var po = parseInt(ad.po);
                   //将要激活
                   if (step == 1) {
                       //已经安装
                       if ((ad.status == easouwall.status.ACTIVATE_INSTALLED) || (ad.status == easouwall.status.UNACTIVATE_INSTALLED)) {
                           html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                           html += '<span id="status_' + ad.id + '">已安装</span>';
                       } else {
                           html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                           html += '<span id="status_' + ad.id + '">送<span class="color">' + ad.show_po + '</span>' + easouwall.currencyName + '</span>';
                       }
                   } else if (step == 2) { //多步骤返积分，执行到第二步
                       if (po > 0) { //第二步在有效时间范围内，可以执行第二步
                           ad.btnName = "签到"; //强制改为"签到"
                           html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                           html += '<span id="status_' + ad.id + '">送<span class="color">' + ad.show_po + '</span>' + easouwall.currencyName + '</span>';
                       } else { //多步骤返积分，有效时间未到，执行第二步无效
                           html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                           html += '<span id="status_' + ad.id + '">已安装</span>';
                       }
                   } else if (step == 3) { //任务已经完成
                       html += '<div id="btnName" class="points">' + ad.btnName + '</div>';
                       html += '<span id="status_' + ad.id + '">已安装</span>';
                   }
                   html += '</div>';
                   html += '<div class="cb"></div>';
               html += '</div>';
           html += '</div>';
       html += '</a>';
    html += '</div>';
   html += '</li>';
return html;
};

/**
 * 显示广告细节
 * @param item
 */
easouwall.showAdDetail = function(item) {
    var ad = easouwall.getAdById(item.id);
    //发送广告点击日志
    easouwall.sendLog(ad.clog);

  //拼接广告详情页
    var html = '<div id="container">';
            html += '<header>';
                html += '<div class="clearfix">';
                    html += '<h1>';
                        html += '<div class="back">';
                            html += '<a onclick="easouwall.returnMainPage()"><img src="./images/back.png" alt=""></a>';
                        html += '</div>';
                        html += '<div class="center"><span style=\'vertical-align:middle;\'>免费赚取' + easouwall.currencyName + '</span><img style="width:60px;vertical-align:middle;" src="images/logo.png"/></div>';
                    html += '</h1>';
            html += '</header>';
            html += '<div id="main" style="margin-top: 45px">';
                html += '<section>';
                    html += '<div class="sw-info">';
                        html += '<div class="fun-btn">';
                            var step = parseInt(ad.step);
                            var po = parseInt(ad.po);
                            if (step == 1) {
                                //已经安装
                                if ((ad.status == easouwall.status.ACTIVATE_INSTALLED) || (ad.status == easouwall.status.UNACTIVATE_INSTALLED)) {
                                    html += '<p class="jifen">已安装</p>';
                                } else {
                                    html += '<p class="jifen">送<span class="color">' + ad.po + '</span>' + easouwall.currencyName +'</p>';
                                }
                            } else if (step == 2) {
                                if (po > 0) {
                                    html += '<p class="jifen">送<span class="color">' + ad.po + '</span>' + easouwall.currencyName +'</p>';
                                } else {
                                    html += '<p class="jifen">已安装</p>';
                                }
                            } else if (step == 3) {
                                html += '<p class="jifen">已安装</p>';
                            }
                            html += '<p><a href="#" onclick="easouwall.handleAction(' + ad.id + ')" title="" id="down1" class="load-btn">' + ad.btnName + '</a></p>';
                        html += '</div>';
                        html += '<div class="sw-img">';
                            html += '<img src="' + ad.logo + '" width="60px" style="border-radius: 5px">';
                        html += '</div>';
                        html += '<div class="sw-text">';
                            html += '<p class="tle">' + ad.name + '</p>';
                            html += '<p class="banben"></p>';
                            html += '<p class="daxiao">大小&nbsp;&nbsp;' + (Math.round(ad.pksz/10)) / 100 + 'M</p>';
                        html += '</div>';
                        //任务已经完成，不再显示积分获取步骤
                        if (parseInt(ad.step) != 3) {
                            html += '<p id="stepInfo' + ad.id + '" class="slogan" style="height: 100%; font-size: 13px; font-weight: lighter; padding: 2px;"><div style="border:1px dashed #19b9ff;text-align: left;padding: 5px;margin-top:15px;color: #fd7741;">' + ad.step_info + '<br/>&nbsp;<span style="color:#BA8300">在未完成以上所有步骤前切勿卸载</span></div></p>';
                        } else {
                            html += '<div style="height: 20px"></div>';
                        }

                    html += '</div>';
                    html += '<div id="progress' + ad.id + '" class="progress-bar blue stripes" style="display:none"><span id="progressData' + ad.id + '"></span></div>';

                    html += '<div class="sw-des">';
                        html += '<p>' + ad.desc2 + '<br></p>';
                        html += '<p>';
                            html += '<img src="' + ad.image1 + '" width="140px"/>';
                            html += '<img src="' + ad.image2 + '" width="140px"/>';
                        html += '</p>';
                    html += '</div>';
                    html += '<div class="fun_btn black">';
                        html += '<a href="#" onclick="easouwall.handleDownload(' + ad.id + ')"  title="">立即下载安装&gt;&gt;</a>';
                    html += '</div>';
                    html += '<div class="clearfix bfont">';
                        html += ad.company;
                    html += '</div>';
                html += '</section>';
            html += '</div>';
        html += '</div>';
    //隐藏主页
    $(".wrap").hide();

    //显示详情页
    $("#detail").show();
    $("#detail").html(html);
};

/**
 * 从OC获取并初始化开发者id
 */
easouwall.initPublisherId = function() {
	easouwall.bridge.send("getPublisherId", function(responseData){
		easouwall.publisherId = responseData;
    });
};

easouwall.setCurrencyName = function(name) {
	easouwall.bridge.callHandler("setCurrencyName", name, function(responseData){});
};

/**
 * 从OC获取并保存配置参数
 */
easouwall.initAdServerSettings = function() {
	easouwall.bridge.send("getServerSettings", function(responseData){
		easouwall.settings = $.parseJSON(responseData);
        //os=2和ct=2代表IOS积分墙
		easouwall.settings.os = "2";
		easouwall.settings.ct = "2";
		easouwall.settings.type = easouwall.type;

		//发送pvcall日志
		easouwall.pvCall();
		easouwall.loadConfig();
		easouwall.initIsEmulator();
    });
};

/**
 * 初始化是否运行在模拟器中
 */
easouwall.initIsEmulator = function(){
	easouwall.bridge.send("isEmulator", function(responseData){
		easouwall.isEmulator = responseData;
		easouwall.loadAd("offerlist");
    });
};

easouwall.sendLog = function(url) {
	easouwall.bridge.callHandler("sendLog", url, function(responseData){});
};

easouwall.sendLogWithCallback = function(url, callback) {
	easouwall.bridge.callHandler("sendLogWithCallback", url, function(responseData){
        callback(responseData);
    });
};
/**
 * 关闭积分墙
 */
easouwall.close = function() {
	easouwall.bridge.send("dismissAdWebView", function(){
        return false;
    });
};

easouwall.pvCall = function() {
    var muid = easouwall.settings.muid;
    var mmid = easouwall.settings.mmid;
    if (muid && mmid) {
        var pvcall = "http://pvcall.easou.com/uishow.png?os=2&mt=12&t=" + (new Date().getTime()) + "&muid=" + muid + "&mmid=" + mmid;
        easouwall.sendLog(pvcall);
    }
};

/**
 * 返回到主页
 */
easouwall.returnMainPage = function() {
    $(".wrap").show();
    $("#detail").children().remove();
    $("#detail").hide();
};

/**
 * 处理广告动作，如试用、注册等
 * @param id 广告标识
 */
easouwall.handleAction = function(id) {
	easouwall.bridge.callHandler('onTaskStart',easouwall.jsonToString(easouwall.getAdById(id)), function(responseData){});
};

/**
 * 根据id从服务器返回的广告中获取广告数据
 * @param id
 * @returns {*}
 */
easouwall.getAdById = function(id) {
	var adsCache;
	if(easouwall.type=="offerlist"){
		adsCache = easouwall.adsCache0;
	}else if(easouwall.type=="appofferlist"){
		adsCache = easouwall.adsCache1;
	}
    for(var i = 0; i < adsCache.length; i++) {
        if (adsCache[i].id == id) {
            return adsCache[i];
        }
    }
};

/**
 * 下载
 * @param id
 */
easouwall.handleDownload = function(id) {
    var ad = easouwall.getAdById(id);
    var clonedAd = {};
    $.extend(clonedAd, ad);
    clonedAd.status = easouwall.status.UNACTIVATE_UNDOWNLOADED;
    easouwall.bridge.callHandler('onTaskStart',easouwall.jsonToString(clonedAd), function(responseData){});
};

var Easou = window.Easou || {};
Easou.offerManager = {};

/**
 * 积分发生变化后更新界面上的积分
 * SDK-JS交互接口，不可混淆
 * @param points
 */
Easou.offerManager.updatePoints = function(points) {
	easouwall.updatePoints(points);
};

/**
 * 通知app激活
 * SDK-JS交互接口，不可混淆
 * @param adid
 */
Easou.offerManager.active =function(adid) {
    var ad = easouwall.getAdById(adid);
    if (ad) {
        ad.status = easouwall.status.ACTIVATE_INSTALLED;
        ad.po = 0;
        $("#status_"+adid).children().remove();
        $("#status_"+adid).html("已安装");
      //返回到主页面
        easouwall.returnMainPage();
    }
};

/**
 * app安装完成后回调
 * SDK-JS交互接口，不可混淆
 * @param adid
 */
Easou.offerManager.installFinish = function(adid) {
    console.info("Easou.offerManager.installFinish :" + adid);
    var ad = easouwall.getAdById(adid);
    if (ad) {
        if (ad.status.indexOf("ACTIVATE_") == 0) {
            ad.status = easouwall.status.ACTIVATE_INSTALLED;
        } else {
            ad.status = easouwall.status.UNACTIVATE_INSTALLED;
        }
    }
    //返回到主界面
    easouwall.returnMainPage();
    $("#status_"+adid).html("已安装");
};

function nav_click(_this){
	var cache = [];
	var id = $(_this).attr("id");
	var _class = $(_this).attr("class");
	if(_class != 'active'){
		easouwall.type = id;
		easouwall.settings.type = id;
		if(id=="offerlist"){
			$("#appofferlist").removeClass('active');
		}else if(id=="appofferlist"){
			$("#offerlist").removeClass('active');
		}
		$(_this).addClass('active');
		//内容重置
		var $list = $("#list");
		$list.html("");
		if((id=="offerlist" && easouwall.adsCache0.length == 0) || (id=="appofferlist" && easouwall.adsCache1.length == 0)){
			$("#loading").show();
			easouwall.loadAd(id);
			return;
		}else if(id=="offerlist"){
			cache = easouwall.adsCache0;
		}else if(id=="appofferlist"){
			cache = easouwall.adsCache1;
		}
		if (cache.length > 0) {
			var tmpArr = [];
			for (var i = 0; i < cache.length; i++) {
               var ad = cache[i];
               tmpArr.push(easouwall.jsonToString(ad));
           }
			var checkStr = "[" + tmpArr.join(",") + "]";
			//检测广告状态，如正在下载、已经下载、已经激活等
			easouwall.bridge.callHandler('checkApkStatus', checkStr, function(responseData) {
				var adData = eval(responseData);
				var el = "";
				for (var i = 0; i < adData.length; i ++) {
					var curAd = adData[i];
					if (easouwall.isEmulator) {//模拟器中全显示为已完成
						curAd.po = 0;
						curAd.show_po = 0;
						curAd.status = curAd.status.replace("UNACTIVATE_", "ACTIVATE_");
					}
					//广告数据解析成html
					el += easouwall.generateAdHtml(curAd);
				}
				$list.append(el);
			});
       }
	}
	
};
