/*
 * Decompiled with CFR 0.152.
 */
package com.easou.ecom;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RealIpUtils {
    public static final String VERSION = "1.2.1";
    private static long IP_A_START = RealIpUtils.ip2long("10.0.0.0");
    private static long IP_A_END = RealIpUtils.ip2long("10.255.255.255");
    private static long IP_B_START = RealIpUtils.ip2long("172.16.0.0");
    private static long IP_B_END = RealIpUtils.ip2long("172.31.255.255");
    private static long IP_C_START = RealIpUtils.ip2long("192.168.0.0");
    private static long IP_C_END = RealIpUtils.ip2long("192.168.255.255");
    private static long IP_SAVE_START = RealIpUtils.ip2long("127.0.0.0");
    private static long IP_SAVE_END = RealIpUtils.ip2long("127.255.255.255");
    private static Map<String, HeaderIpHandler> HEADER_HANDLERS = new LinkedHashMap<String, HeaderIpHandler>(){
        {
            BaseHeaderIpHandler defaultHandler = new BaseHeaderIpHandler();
            HeaderIpHandler xffHandler = new HeaderIpHandler(){

                @Override
                public String getIp(String value) {
                    String[] ipList;
                    if (value == null || value.isEmpty()) {
                        return "";
                    }
                    for (String nowIp : ipList = value.split(",")) {
                        long ip;
                        if (nowIp != null && !nowIp.isEmpty()) {
                            nowIp = nowIp.trim();
                        }
                        if ((ip = RealIpUtils.ip2long(nowIp)) <= 0L || RealIpUtils.isInnerIp(ip)) continue;
                        return nowIp;
                    }
                    return "";
                }
            };
            this.put("clientip", defaultHandler);
            this.put("x-source-id", defaultHandler);
            this.put("x-huawei-sgsnip", defaultHandler);
            this.put("x-huawei-nasip", defaultHandler);
            this.put("cdn-src-ip", defaultHandler);
            this.put("x-surfcache-for", defaultHandler);
            this.put("x-real-ip", defaultHandler);
            this.put("proxy-client-ip", defaultHandler);
            this.put("wl-proxy-client-ip", defaultHandler);
            this.put("x-forwarded-for", xffHandler);
            this.put("x_forwarded_for", xffHandler);
            this.put("x-forwarded-for2", xffHandler);
        }
    };

    public static String getRealIpAddress(HttpServletRequest request) {
        HashMap<String, String> header = new HashMap<String, String>(100);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String key = name.toLowerCase();
            if (!HEADER_HANDLERS.containsKey(key)) continue;
            header.put(key, request.getHeader(name));
        }
        String realip = RealIpUtils.getRealIpFromHeaders(header);
        if (!realip.isEmpty()) {
            return realip;
        }
        return request.getRemoteAddr();
    }

    public static String getRealIpFromHeaders(Map<String, String> header) {
        for (Map.Entry<String, HeaderIpHandler> e : HEADER_HANDLERS.entrySet()) {
            String realip;
            String value = header.get(e.getKey());
            if (value != null && !value.isEmpty()) {
                value = value.trim();
            }
            if ((realip = e.getValue().getIp(value)).isEmpty()) continue;
            return realip;
        }
        return "";
    }

    public static boolean isInnerIp(long ip) {
        return RealIpUtils.isInner(ip, IP_A_START, IP_A_END) || RealIpUtils.isInner(ip, IP_B_START, IP_B_END) || RealIpUtils.isInner(ip, IP_C_START, IP_C_END) || RealIpUtils.isInner(ip, IP_SAVE_START, IP_SAVE_END);
    }

    private static boolean isInner(long ip, long begin, long end) {
        return ip >= begin && ip <= end;
    }

    public static long ip2long(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            return -1L;
        }
        long ip = 0L;
        long v = 0L;
        int p1 = 0;
        int p2 = 0;
        p2 = ipAddress.indexOf(46, p1);
        if (p2 < 0) {
            return -1L;
        }
        try {
            v = Long.parseLong(ipAddress.substring(p1, p2));
            if (v < 0L || v > 255L) {
                return -1L;
            }
            ip |= v << 24;
            p1 = p2 + 1;
            if ((p2 = ipAddress.indexOf(46, p1)) < 0) {
                return -1L;
            }
            v = Long.parseLong(ipAddress.substring(p1, p2));
            if (v < 0L || v > 255L) {
                return -1L;
            }
            ip |= v << 16;
            p1 = p2 + 1;
            if ((p2 = ipAddress.indexOf(46, p1)) < 0) {
                return -1L;
            }
            v = Long.parseLong(ipAddress.substring(p1, p2));
            if (v < 0L || v > 255L) {
                return -1L;
            }
            ip |= v << 8;
            v = Long.parseLong(ipAddress.substring(p2 + 1));
            if (v < 0L || v > 255L) {
                return -1L;
            }
            return ip |= v;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public static String long2ip(long ipaddress) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(ipaddress >>> 24));
        sb.append(".");
        sb.append(String.valueOf((ipaddress & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((ipaddress & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(ipaddress & 0xFFL));
        return sb.toString();
    }

    private static class BaseHeaderIpHandler
    implements HeaderIpHandler {
        private BaseHeaderIpHandler() {
        }

        @Override
        public String getIp(String value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            long ip = RealIpUtils.ip2long(value);
            return ip < 0L || RealIpUtils.isInnerIp(ip) ? "" : value;
        }
    }

    public static interface HeaderIpHandler {
        public String getIp(String var1);
    }
}

