/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient;

import com.easou.novel.searchclient.model.HotSearchResponse;
import com.easou.novel.searchclient.model.HotWord;
import com.easou.novel.searchclient.model.HotWordParam;
import com.easou.novel.searchclient.search.HotSearchSearcher;
import com.easou.novel.searchclient.search.SearchRequest;
import com.easou.novel.searchclient.util.ConfigUtil;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpHotSearchClient {
    private static final Logger log = Logger.getLogger(HttpHotSearchClient.class);
    private static final String SERVER_ADDR = ConfigUtil.get("hot.search.server", "");

    public static HotSearchResponse getHotSearch(String version, String os, String resolution, String uid, String udid, String phone, String ch, String appVersion, int clearCache, int appid, int regionLevel) {
        HotWordParam hotwordParam = new HotWordParam();
        hotwordParam.setVersion(version);
        hotwordParam.setOs(os);
        hotwordParam.setUid(uid);
        hotwordParam.setUdid(udid);
        hotwordParam.setChannal(ch);
        hotwordParam.setAppid(appid);
        hotwordParam.setRegionLevel(regionLevel);
        hotwordParam.setdType("0");
        hotwordParam.setUserLevel(0);
        hotwordParam.setUserAge(1);
        hotwordParam.setUserPay(4);
        hotwordParam.setUserInitPay(2);
        return HttpHotSearchClient.getHotSearch(hotwordParam);
    }

    public static HotSearchResponse getHotSearch(HotWordParam hotWordParam) {
        StringBuilder sb = new StringBuilder(SERVER_ADDR);
        sb.append("?").append("version=").append(hotWordParam.getVersion()).append("&os=").append(hotWordParam.getOs()).append("&uid=").append(hotWordParam.getUid()).append("&udid=").append(hotWordParam.getUdid()).append("&channel=").append(hotWordParam.getChannal()).append("&clearCache=").append(hotWordParam.getClearCache()).append("&appid=").append(hotWordParam.getAppid()).append("&regionLevel=").append(hotWordParam.getRegionLevel()).append("&dType=").append(hotWordParam.getdType()).append("&userLevel=").append(hotWordParam.getUserLevel()).append("&userAge=").append(hotWordParam.getUserAge()).append("&userPay=").append(hotWordParam.getUserPay()).append("&userInitPay=").append(hotWordParam.getUserInitPay());
        HotSearchSearcher searcher = new HotSearchSearcher(new SearchRequest(sb.toString()));
        searcher.exec();
        String content = searcher.getResult();
        HotSearchResponse response = null;
        try {
            response = HttpHotSearchClient.parseResponse(content);
        }
        catch (Exception e) {
            log.debug((Object)("back message: " + content));
            log.error((Object)"get data error, ", (Throwable)e);
        }
        return response;
    }

    private static HotSearchResponse parseResponse(String content) throws Exception {
        JSONObject object = new JSONObject(content);
        HotSearchResponse response = new HotSearchResponse();
        boolean success = object.getBoolean("success");
        if (success) {
            ArrayList<HotWord> hotWords = new ArrayList<HotWord>();
            JSONArray array = object.getJSONArray("words");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                HotWord hw = new HotWord();
                hw.setWord(obj.getString("word"));
                hw.setType(obj.getInt("type"));
                hw.setGid(obj.optInt("gid", 0));
                hotWords.add(hw);
            }
            ArrayList<HotWord> defaultWords = new ArrayList<HotWord>();
            if (object.has("defaultWords")) {
                JSONArray defaultArray = object.getJSONArray("defaultWords");
                for (int i = 0; i < defaultArray.length(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    HotWord hw = new HotWord();
                    hw.setWord(obj.getString("word"));
                    hw.setType(obj.getInt("type"));
                    defaultWords.add(hw);
                }
            }
            response.setHotWords(hotWords);
            response.setDefaultWords(defaultWords);
        }
        return response;
    }
}

