/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient;

import com.easou.novel.searchclient.model.SuggestionParam;
import com.easou.novel.searchclient.model.SuggestionResult;
import com.easou.novel.searchclient.search.SuggestionSearcher;
import com.easou.novel.searchclient.util.ConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpSuggestionClient {
    private static Logger log = Logger.getLogger(HttpSuggestionClient.class);
    private static final List<SuggestionResult> EMPTY = new ArrayList<SuggestionResult>();
    private static final String SERVER = ConfigUtil.getSysConfig().get("suggestion.service");

    public List<SuggestionResult> suggestion(String query, int appid) {
        SuggestionParam sugParam = new SuggestionParam();
        sugParam.setQuery(query);
        sugParam.setAppid(appid);
        sugParam.setdType("0");
        sugParam.setRegionLevel(1);
        sugParam.setUserLevel(0);
        sugParam.setUserAge(1);
        return this.suggestion(sugParam);
    }

    public List<SuggestionResult> suggestion(SuggestionParam sugParam) {
        return this.doSuggestion(sugParam);
    }

    public List<SuggestionResult> suggestion4Vip(String query, int appid) {
        SuggestionParam sugParam = new SuggestionParam();
        sugParam.setQuery(query);
        sugParam.setAppid(appid);
        sugParam.setdType("5");
        sugParam.setRegionLevel(1);
        sugParam.setUserLevel(0);
        sugParam.setUserAge(1);
        sugParam.setUserPay(4);
        sugParam.setUserInitPay(2);
        return this.suggestion4Vip(sugParam);
    }

    public List<SuggestionResult> suggestion4Vip(SuggestionParam sugParam) {
        if (sugParam.getdType() != "5") {
            sugParam.setdType("5");
        }
        return this.doSuggestion(sugParam);
    }

    private List<SuggestionResult> doSuggestion(SuggestionParam sugParam) {
        if (StringUtils.isBlank((String)sugParam.getQuery())) {
            return EMPTY;
        }
        String query = sugParam.getQuery();
        try {
            query = URLEncoder.encode(sugParam.getQuery(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        StringBuilder url = new StringBuilder(SERVER);
        url.append("?query=").append(sugParam.getQuery()).append("&appid=").append(sugParam.getAppid()).append("&dtype=").append(sugParam.getdType()).append("&regionLevel=").append(sugParam.getRegionLevel()).append("&userLevel=").append(sugParam.getUserLevel()).append("&userAge=").append(sugParam.getUserAge()).append("&userPay=").append(sugParam.getUserPay()).append("&userInitPay=").append(sugParam.getUserInitPay());
        if (log.isDebugEnabled()) {
            log.debug((Object)("search url:" + url));
        }
        List<SuggestionResult> response = null;
        try {
            SuggestionSearcher searcher = new SuggestionSearcher(url.toString());
            searcher.exec();
            String content = searcher.getResult();
            if (log.isDebugEnabled()) {
                log.debug((Object)("search content:" + content));
            }
            if (!StringUtils.isBlank((String)content)) {
                response = this.parseResponse(content.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("search response:" + response));
            }
        }
        catch (Exception e) {
            log.error((Object)("Search error, url:" + url.toString()), (Throwable)e);
        }
        return response;
    }

    private List<SuggestionResult> parseResponse(String content) {
        ArrayList<SuggestionResult> results = new ArrayList<SuggestionResult>();
        JSONArray root = new JSONArray(content);
        int n = root.length();
        for (int i = 0; i < n; ++i) {
            SuggestionResult response = new SuggestionResult();
            JSONObject obj = root.getJSONObject(i);
            response.setWord(obj.optString("title", ""));
            response.setType(obj.optInt("type", 0));
            response.setGid(obj.optInt("gid", 0));
            response.setBoost(obj.optDouble("boost", 0.0));
            results.add(response);
        }
        return results;
    }

    public static void main(String[] args) {
        HttpSuggestionClient client = new HttpSuggestionClient();
        List<SuggestionResult> results = client.suggestion("d", 1);
        for (SuggestionResult result : results) {
            System.out.println(result.getWord());
        }
        System.out.println("-----------------");
        results = client.suggestion4Vip("d", 1);
        for (SuggestionResult result : results) {
            System.out.println(result.getWord());
        }
    }
}

