/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.impl;

import com.easou.novel.searchclient.impl.SearchClientImpl;
import com.easou.novel.searchclient.model.HitDetails;
import com.easou.novel.searchclient.model.SearchParam;
import com.easou.novel.searchclient.model.SearchResponse;
import com.easou.novel.searchclient.util.ConfigUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class OldClientImpl
extends SearchClientImpl<SearchResponse> {
    private static final String SERVER = "http://" + ConfigUtil.getSysConfig().get("search.server.olddomain") + ConfigUtil.getSysConfig().get("search.server.context");

    public SearchResponse search(SearchParam param) {
        param.setdType("1");
        return (SearchResponse)this.doSearch(param);
    }

    public SearchResponse searchPaid(SearchParam param) {
        param.setdType("12");
        return (SearchResponse)this.doSearch(param);
    }

    public SearchResponse searchAll(SearchParam param) {
        param.setdType("12");
        return (SearchResponse)this.doSearch(param);
    }

    public SearchResponse search4Charge(SearchParam param) {
        param.setdType("2");
        return (SearchResponse)this.doSearch(param);
    }

    @Override
    protected SearchResponse parseResponse(String content) {
        SearchResponse response = new SearchResponse();
        if (StringUtils.isEmpty((String)content)) {
            return response;
        }
        try {
            JSONObject root = new JSONObject(content);
            response.setTotal(root.optInt("allTotal", 0));
            response.setShowTotal(root.optInt("total", 0));
            response.setCheckWord(root.optString("check_word", ""));
            response.setKeyWord(root.optString("keyWord", ""));
            response.setSearchType(root.optInt("type", 0));
            response.setSortType(root.optInt("sortType", 0));
            JSONArray items = root.optJSONArray("all_book_items");
            int length = 0;
            if (items != null && (length = items.length()) > 0) {
                ArrayList<HitDetails> details = new ArrayList<HitDetails>();
                for (int i = 0; i < length; ++i) {
                    JSONObject item = items.getJSONObject(i);
                    HitDetails detail = this.convert(item);
                    if (detail == null) continue;
                    details.add(detail);
                }
                response.setResults(details);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private HitDetails convert(JSONObject item) {
        if (item != null) {
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
            fields.put("sourceid", item.optString("sourceId", "\uff10"));
            fields.put("cpid", item.optString("cpId", "-1"));
            fields.put("nType", item.optString("nType", "1"));
            fields.put("class", item.optString("classPinyin", ""));
            fields.put("classes", item.optString("category", ""));
            fields.put("sclasses", item.optString("label", ""));
            fields.put("description", item.optString("desc", ""));
            fields.put("webfromCount", item.optString("webfromCount", "0"));
            fields.put("imgurl", item.optString("imgUrl", ""));
            fields.put("docid", item.optString("nid", "0"));
            fields.put("pv", item.optString("subscribeCount", "0"));
            fields.put("gid", item.optString("gid", "0"));
            fields.put("site", item.optString("site", ""));
            fields.put("attribute", item.optString("status", "").equals("\u8fde\u8f7d") ? "1" : "2");
            fields.put("author", item.optString("author", ""));
            fields.put("light", item.optString("light", "0"));
            fields.put("chapterCount", item.optString("chapterCount", "0"));
            fields.put("title", item.optString("name", ""));
            fields.put("intime", item.optString("inTime", "0"));
            int size = fields.size();
            return new HitDetails(fields.keySet().toArray(new String[size]), fields.values().toArray(new String[size]));
        }
        return null;
    }

    @Override
    protected String getServer() {
        return SERVER;
    }
}

