/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.impl;

import com.easou.novel.searchclient.HttpSearchClient;
import com.easou.novel.searchclient.model.NovelGid;
import com.easou.novel.searchclient.model.SearchParam;
import com.easou.novel.searchclient.model.SearchResponse;
import com.easou.novel.searchclient.search.SearchSearcher;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class SearchClientImpl<T> {
    private static Logger log = Logger.getLogger(HttpSearchClient.class);
    private static final SearchResponse EMPTY = new SearchResponse();
    private static final String EMPTY_CONTENT = new JSONObject().toString();
    protected SearchParam param;

    public T doSearch(SearchParam param) {
        this.param = param;
        T response = null;
        String content = this.doHttpRequest(param, this.getServer());
        if (!StringUtils.isBlank((String)content)) {
            response = this.parseResponse(content);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("search response:" + response));
        }
        return response;
    }

    protected String doHttpRequest(SearchParam param, String server) {
        String query = param.getQuery();
        if (StringUtils.isBlank((String)query)) {
            return EMPTY_CONTENT;
        }
        try {
            query = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        StringBuilder url = new StringBuilder(server);
        url.append("?word=").append(query).append("&page_id=").append(param.getPageId()).append("&count=").append(param.getPageSize()).append("&type=").append(param.getSearchType()).append("&sort_type=").append(param.getSortType()).append("&highlight=").append(param.getHighlight()).append("&dType=").append(param.getdType()).append("&uid=").append(param.getUid()).append("&udid=").append(param.getUdid()).append("&ch=").append(param.getChannal()).append("&version=").append(param.getVersion()).append("&os=").append(param.getOs()).append("&cid=").append(param.getCid()).append("&source=").append("api").append("&appid=").append(param.getAppid()).append("&wc=").append(param.getWc()).append("&showj=").append(param.getShowj()).append("&scp=").append(param.getScp()).append("&status=").append(param.getStatus()).append("&catalog=").append(param.getCatalog()).append("&userLevel=").append(param.getUserLevel()).append("&regionLevel=").append(param.getRegionLevel()).append("&userPay=").append(param.getUserPay()).append("&userAge=").append(param.getUserAge()).append("&from=").append(param.getFrom()).append("&userInitPay=").append(param.getUserInitPay()).append("&catalogGender=").append(param.getCatalogGender());
        if (log.isDebugEnabled()) {
            log.debug((Object)("search url:" + url));
        }
        try {
            SearchSearcher searcher = new SearchSearcher(url.toString());
            searcher.exec();
            String content = searcher.getResult();
            if (log.isDebugEnabled()) {
                log.debug((Object)("search content:" + content));
            }
            return content;
        }
        catch (Exception e) {
            log.error((Object)("Search error, url:" + url.toString()), (Throwable)e);
            return EMPTY_CONTENT;
        }
    }

    protected List<NovelGid> convert2Gid(JSONArray items) {
        ArrayList<NovelGid> gids = null;
        int resultLength = 0;
        if (items != null && (resultLength = items.length()) > 0) {
            gids = new ArrayList<NovelGid>(resultLength);
            for (int i = 0; i < resultLength; ++i) {
                NovelGid ngid = this.convert2Gid(items.getJSONObject(i));
                if (ngid == null) continue;
                gids.add(ngid);
            }
        } else {
            gids = Collections.EMPTY_LIST;
        }
        return gids;
    }

    protected NovelGid convert2Gid(JSONObject item) {
        int gid = 0;
        if (item != null && (gid = item.optInt("gid", -1)) > -1) {
            int nidSize = 0;
            NovelGid ngid = new NovelGid(gid);
            JSONArray nidArray = item.optJSONArray("nids");
            if (nidArray != null && (nidSize = nidArray.length()) > 0) {
                ArrayList<Integer> nids = new ArrayList<Integer>(nidSize);
                for (int j = 0; j < nidSize; ++j) {
                    int nid = nidArray.optInt(j);
                    if (nid <= 0) continue;
                    nids.add(nid);
                }
                ngid.setNids(nids);
            }
            return ngid;
        }
        return null;
    }

    protected abstract T parseResponse(String var1);

    protected abstract String getServer();
}

