/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.search;

import com.easou.novel.searchclient.http.HttpExecutor;
import com.easou.novel.searchclient.search.SearchRequest;
import com.easou.novel.searchclient.threadpool.NvThreadPoolExecutor;
import com.easou.novel.searchclient.util.LogFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class BaseSearcher {
    private long startTime = System.currentTimeMillis();
    protected SearchRequest request = null;
    protected HttpExecutor httpExecutor = null;
    protected NvThreadPoolExecutor executor = null;
    protected Future<String> future = null;

    public BaseSearcher(SearchRequest request) {
        this.request = request;
        this.executor = this.initPool();
        this.httpExecutor = new HttpExecutor(this.request.getSearchUrl());
    }

    protected abstract NvThreadPoolExecutor initPool();

    public void exec() {
        this.startTime = System.currentTimeMillis();
        this.future = this.executor.submit(new Callable<String>(){

            @Override
            public String call() {
                LogFactory.LOG.debug(new Object[]{"BaseSearcher: start exec >>>", Thread.currentThread().getName(), Thread.currentThread().getId(), BaseSearcher.this.request.getSearchUrl()});
                return BaseSearcher.this.search();
            }
        });
    }

    protected String search() {
        return this.httpExecutor.getHttpBody();
    }

    public String getResult() {
        String result = "";
        if (this.future == null) {
            return result;
        }
        long pastTime = System.currentTimeMillis() - this.startTime;
        long waitTime = this.maxSearchWaitMillis() - pastTime;
        long pastTimeFinal = 0L;
        if (waitTime < 0L) {
            waitTime = 0L;
        }
        try {
            result = this.future.get(waitTime, TimeUnit.MILLISECONDS);
            if (result == null) {
                result = "";
            }
            pastTimeFinal = System.currentTimeMillis() - this.startTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = this.onException();
        }
        LogFactory.LOG.debug(new Object[]{"BaseSearcher: result > pastTimeFinal:", pastTimeFinal, ",pastTime1:", pastTime, ",perWaitTime:", waitTime, ",getResult:", result});
        return result;
    }

    protected String onException() {
        this.httpExecutor.abort();
        this.future.cancel(true);
        return "";
    }

    protected long maxSearchWaitMillis() {
        return 500L;
    }
}

