/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.search;

import com.easou.novel.searchclient.model.RecommParam;
import com.easou.novel.searchclient.search.SearchRequest;
import com.easou.novel.searchclient.util.ConfigUtil;
import com.easou.novel.searchclient.util.Constant;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class RecommendRequest
extends SearchRequest {
    private static final String RECOMMEND_HTTPSERVICE_DEFAULT = "http://10.26.24.27/recomm.json";
    private static final String RECOMM_SERVER = ConfigUtil.get("recommend.httpService", "http://10.26.24.27/recomm.json");
    private static final String RECOMM_SERVER_WEIJUAN = ConfigUtil.get("recommend.httpServiceWeijuan", "http://10.26.24.27/recomm.json");
    private RecommParam paramObj;

    private RecommendRequest(RecommParam paramObj) {
        if (paramObj == null) {
            paramObj = new RecommParam();
        }
        this.paramObj = paramObj;
    }

    public RecommendRequest(String url) {
        super(url);
    }

    public static RecommendRequest builder(String url) {
        return new RecommendRequest(url);
    }

    public static RecommendRequest builderForBean(RecommParam param) {
        RecommendRequest request = new RecommendRequest(param);
        request.fitUrl();
        return request;
    }

    public String fitUrl() {
        StringBuffer sb = null;
        sb = "10001".equals(this.paramObj.getAppId()) ? new StringBuffer(RECOMM_SERVER) : new StringBuffer(RECOMM_SERVER_WEIJUAN);
        sb.append("?");
        sb.append("recommType").append("=").append(this.encoding(this.paramObj.getPageRecType()));
        if (StringUtils.isNotBlank((String)this.paramObj.getGid())) {
            sb.append("&");
            sb.append("reqGid").append("=").append(this.encoding(this.paramObj.getGid()));
        }
        sb.append("&");
        sb.append("uid").append("=").append(this.encoding(this.paramObj.getUid()));
        sb.append("&");
        sb.append("udid").append("=").append(this.encoding(this.paramObj.getUdid()));
        if (this.paramObj.getStart() > 0) {
            sb.append("&");
            sb.append("start").append("=").append(this.paramObj.getStart());
        }
        if (this.paramObj.getCount() > 0) {
            sb.append("&");
            sb.append("count").append("=").append(this.paramObj.getCount());
        }
        if (this.paramObj.getCharge() > 0) {
            sb.append("&");
            sb.append("charge").append("=").append(this.paramObj.getCharge());
        }
        if (StringUtils.isNotBlank((String)this.paramObj.getCh())) {
            sb.append("&");
            sb.append("cid").append("=").append(this.encoding(this.paramObj.getCh()));
        }
        if (StringUtils.isNotBlank((String)this.paramObj.getModuleIdsStr())) {
            sb.append("&");
            if (Constant.TYPE_MODULE_MORE.equals(this.paramObj.getPageRecType())) {
                sb.append("moduleId").append("=").append(this.encoding(this.paramObj.getModuleIdsStr()));
            } else {
                sb.append("moduleIds").append("=").append(this.encoding(this.paramObj.getModuleIdsStr()));
            }
        }
        if (this.paramObj.getModCount() > 0) {
            sb.append("&");
            sb.append("modCount").append("=").append(this.paramObj.getModCount());
        }
        if (this.paramObj.getFeature() > 0) {
            sb.append("&");
            sb.append("feature").append("=").append(this.paramObj.getFeature());
        }
        if (StringUtils.isNotBlank((String)this.paramObj.getAppId())) {
            sb.append("&");
            sb.append("appid").append("=").append(this.paramObj.getAppId());
        }
        if (this.paramObj.getCatalogGender() > 0) {
            sb.append("&");
            sb.append("gender").append("=").append(this.paramObj.getCatalogGender());
        }
        if (this.paramObj.getReset() > 0) {
            sb.append("&");
            sb.append("reset").append("=").append(this.paramObj.getReset());
        }
        if (this.paramObj.getScp() > 0) {
            sb.append("&");
            sb.append("scp").append("=").append(this.paramObj.getScp());
        }
        if (this.paramObj.getShowjAd() > 0) {
            sb.append("&");
            sb.append("wjad").append("=").append(this.paramObj.getShowjAd());
        }
        sb.append("&");
        sb.append("regionLevel").append("=").append(this.paramObj.getRegionLevel());
        sb.append("&");
        sb.append("userLevel").append("=").append(this.paramObj.getUserLevel());
        sb.append("&");
        sb.append("userPay").append("=").append(this.paramObj.getUserPay());
        sb.append("&");
        sb.append("userAge").append("=").append(this.paramObj.getUserAge());
        if (StringUtils.isNotBlank((String)this.paramObj.getOs())) {
            sb.append("&");
            sb.append("os").append("=").append(this.encoding(this.paramObj.getOs()));
        }
        if (StringUtils.isNotBlank((String)this.paramObj.getVersion())) {
            sb.append("&");
            sb.append("ver").append("=").append(this.encoding(this.paramObj.getVersion()));
        }
        if (this.paramObj.getUserInitPay() > 0) {
            sb.append("&");
            sb.append("userInitPay").append("=").append(this.paramObj.getUserInitPay());
        }
        String url = sb.toString();
        this.setUrl(url);
        return url;
    }

    public RecommParam getParamObj() {
        return this.paramObj;
    }

    public void setParamObj(RecommParam paramObj) {
        this.paramObj = paramObj;
    }

    private String encoding(String str) {
        String value = "";
        if (StringUtils.isNotBlank((String)str)) {
            try {
                value = URLEncoder.encode(str, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                value = str;
            }
        }
        return value;
    }
}

