/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.threadpool;

import com.easou.novel.searchclient.util.LogFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NvThreadPoolExecutor
extends ThreadPoolExecutor {
    private String executorName;
    private static final int interval = 60000;
    private AtomicLong lastTime = new AtomicLong();
    private AtomicInteger totalActiveCount = new AtomicInteger(0);
    private AtomicInteger processCount = new AtomicInteger(0);

    public NvThreadPoolExecutor(String name, int coreSize, int maxSize, long keepAliveTime, TimeUnit tu, BlockingQueue<Runnable> quene, RejectedExecutionHandler discardOldestPolicy) {
        super(coreSize, maxSize, keepAliveTime, tu, quene, discardOldestPolicy);
        this.executorName = name;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.watch();
        return super.submit(task);
    }

    private void watch() {
        int procCnt = this.processCount.incrementAndGet();
        this.totalActiveCount.addAndGet(this.getActiveCount());
        if (System.currentTimeMillis() - this.lastTime.get() > 60000L) {
            this.lastTime.set(System.currentTimeMillis());
            String msg = "ThreadPool:" + this.executorName + " Executor > active threads:" + this.getActiveCount() + ",current threads:" + this.getPoolSize() + ",queue size:" + this.getQueue().size() + ",avg active threads:" + (float)this.totalActiveCount.get() / (float)procCnt;
            if (this.getQueue().remainingCapacity() < 50) {
                msg = msg + "\nThreadPool:" + this.executorName + " Executor $$quene size near full!$$";
            }
            this.processCount.set(0);
            this.totalActiveCount.set(0);
            LogFactory.LOGPOOL.info(new Object[]{msg});
        }
    }
}

