/*
 * Decompiled with CFR 0.152.
 */
package com.easou.novel.searchclient.threadpool;

import com.easou.novel.searchclient.threadpool.NvThreadPoolExecutor;
import com.easou.novel.searchclient.util.ConfigUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolFactory {
    private static final int DEFAULT_CORE_POOL_SIZE = 20;
    private static final int DEFAULT_MAX_POOL_SIZE = 50;
    private static final int DEFAULT_KEEP_LIVE_TIME = 60000;
    private static final int DEFAULT_MAX_QUENE_SIZE = 10000;
    static final NvThreadPoolExecutor searchPoolExecutor = ThreadPoolFactory.getExecutor("searchpool");
    static final NvThreadPoolExecutor recommendPoolExecutor = ThreadPoolFactory.getExecutor("recommendpool");
    static final NvThreadPoolExecutor suggestionPoolExecutor = ThreadPoolFactory.getExecutor("suggestionpool");
    static final NvThreadPoolExecutor hotSearchPoolExecutor = ThreadPoolFactory.getExecutor("hotsearchpool");

    private static NvThreadPoolExecutor getExecutor(String poolName) {
        int coreSize = ConfigUtil.getInt(poolName + ".corePoolSize", 20);
        int maxSize = ConfigUtil.getInt(poolName + ".maximumPoolSize", 50);
        int keepAliveTime = ConfigUtil.getInt(poolName + ".keepAliveTime", 60000);
        int maxQueneSize = ConfigUtil.getInt(poolName + ".maximumQueueSize", 10000);
        NvThreadPoolExecutor executor = new NvThreadPoolExecutor(poolName, coreSize, maxSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxQueneSize), (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        return executor;
    }

    public static NvThreadPoolExecutor getRecommendPoolExcutor() {
        return recommendPoolExecutor;
    }

    public static NvThreadPoolExecutor getSearchPoolExcutor() {
        return searchPoolExecutor;
    }

    public static NvThreadPoolExecutor getSuggestionPoolExcutor() {
        return suggestionPoolExecutor;
    }

    public static NvThreadPoolExecutor getHotSearchPoolExcutor() {
        return hotSearchPoolExecutor;
    }
}

