package com.easou.ps.common.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

import com.easou.ps.common.servicehandle.ServiceAddress;

public abstract class Factory<T> {
	
	public Factory(){
		
	}

	public abstract T makeChannel(String address);
	
	public abstract boolean validateChannel(T t);
	
	public abstract boolean validateHandle(String address);
	
	public abstract void destoryChannel(T t);
	
	public void destoryHandle(ServiceHandle<T> handle){
		List<T> channels = handle.channels();
		for (T t : channels){
			destoryChannel(t);
		}
	}
	
	public int replenishChannel(ServiceHandle<T> handle, int maxSize){
		int need = maxSize - handle.channelSize();
		if (need > 0 ){
			List<T> append = new ArrayList<T>();
			for (int i=0; i<need; i++){
				T t  = makeChannel(handle.getAddress());
				if ( t != null){
					append.add(t);
				}
			}
			handle.addChannel(append);
		}
		return need;
	}
	
	/**
	 * socket 可用检查
	 * @param host
	 * @param port
	 * @param connTimeout
	 * @return
	 */
	protected boolean socketCheck(String host, int port, int connTimeout) {
		boolean success = false;
		Socket socket = null;
		try {
			socket = new Socket();
			socket.setSoLinger(true, 0);
			socket.connect(new InetSocketAddress(host, port), connTimeout);
			success = true;
		} catch (Exception e) {
			;
		} finally {
			if (socket != null) {
				try {
					socket.close();
				} catch (Exception e) {
				}
			}
		}
		return success;
	}
	
}
