package com.easou.ps.common.pool;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class ServiceHandle<T> {
	
	// 服务器地址ip:port
	private String address;
	private AtomicInteger seq = new AtomicInteger(0) ;
	private CopyOnWriteArrayList<T> channels = new  CopyOnWriteArrayList<T>();
	private volatile Map<T, Object>  invalidChannels = new HashMap<T, Object>();
	private ReentrantLock lock = new ReentrantLock();
	
	ServiceHandle(String address) {
		this.address = address;
	}

	T getChannel(){
		int size = channels.size();
		if (size > 0){
			int  c = seq.incrementAndGet();
			c = Math.abs(c);
			int index = c % size;
			if (index <channels.size()){
				try {
					return channels.get(index);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return null;
	}
	
	boolean invalid(T t){
		lock.lock();
		try {
			invalidChannels.put(t, null);
		} finally {
			lock.unlock();
		}
		return true;
	}
	
	boolean addChannel(List<T> t){
		return channels.addAll(t);
	}
	
	String getAddress(){
		return address;
	}
	
	int channelSize (){
		return channels.size();
	}
	
	List<T> channels(){
		return channels;
	}
	
	Collection<T> invalidChannels(){
		Collection<T> returnList = null;
		lock.lock();
		try {
			if (invalidChannels.size()>0){
				returnList = invalidChannels.keySet();
				invalidChannels = new HashMap<T, Object>();
			} else {
				returnList = Collections.emptySet();
			}
		} finally {
			lock.unlock();
		}
		return returnList;
	}
	
	@Override
	public String toString() {
		StringBuilder str = new StringBuilder();
		str.append("Handle(" ).append(channels.size() ).append("/" ).append(channels.size()-invalidChannels.size())
		.append("->").append(address).append(")");
		return str.toString();
	}
}
