    /**
     * Android 锁屏下载详情页
     * User: 谢佩佩
     * Date: 14-6-19
     * Time: 下午16:31
     */

    //定义命名空间
    var easoulocker = window.easoulocker || {};


    //检测是否是模拟器
    easoulocker.isEmulator = false;

    easoulocker.currencyName = "元";

    //当前正在处理的广告
    easoulocker.ad = {};

    /**
     * 积分墙广告对应的4种状态，已下载、未下载、正在下载、已安装
     */
    easoulocker.status = {
        STATUS_DOWNLOADED : "DOWNLOADED",
        STATUS_UNDOWNLOAD : "UNDOWNLOAD",
        STATUS_DOWNLOADING : "DOWNLOADING",
        STATUS_INSTALLED : "INSTALLED"
    };

    /**
     * 初始化
     */
    easoulocker.init = function () {
        easoulocker.showAdDetail();
    };


    /**
     * 处理广告动作，如试用、注册等
     * @param id 广告标识
     */
    easoulocker.handleAction = function(id) {
        window.eslc.onTaskStart(id);
    };

    /**
     * 下载apk包
     * @param id
     */
    easoulocker.handleDownload = function(id) {
        window.eslc.download(id);
    };

    /**
     * 显示广告细节
     * @param item
     */
    easoulocker.showAdDetail = function() {
        var ad = $.parseJSON(window.eslc.getAdHandled());
        //发送广告点击
        window.eslc.sendLog(ad.clog);
        easoulocker.ad = ad;
        //拼接广告详情页
        var html = '<div id="container">';
                html += '<div id="main">';
                    html += '<section>';
                        html += '<div class="sw-info">';
                            html += '<div class="fun-btn">';
                                var step = parseInt(ad.step);
                                var po = parseInt(ad.po);
                                if (step == 1) {
                                    //已经安装
                                    if (ad.status == easoulocker.status.STATUS_INSTALLED) {
                                        html += '<p class="jifen">已安装</p>';
                                    } else {
                                        html += '<p class="jifen">送<span class="color">' + ad.po + '</span>' + easoulocker.currencyName +'</p>';
                                    }
                                } else if (step == 2) {
                                    if (po > 0) {
                                        html += '<p class="jifen">送<span class="color">' + ad.po + '</span>' + easoulocker.currencyName +'</p>';
                                    } else {
                                        html += '<p class="jifen">已安装</p>';
                                    }
                                } else if (step == 3) {
                                    html += '<p class="jifen">已安装</p>';
                                }
                                html += '<p><a href="#" onclick="easoulocker.handleAction(\'' + ad.id + '\')" title="" id="down1" class="load-btn">' + ad.btnName + '</a></p>';
                            html += '</div>';
                            html += '<div class="sw-img">';
                                html += '<img src="' + ad.logo + '" width="60px" style="border-radius: 5px">';
                            html += '</div>';
                            html += '<div class="sw-text">';
                                html += '<p class="tle">' + ad.name + '</p>';
                                html += '<p class="banben"></p>';
                                html += '<p class="daxiao">大小&nbsp;&nbsp;' + (Math.round(ad.pksz/10)) / 100 + 'M</p>';
                            html += '</div>';
                            //任务已经完成，不再显示积分获取步骤
                            if (parseInt(ad.step) != 3) {
                                html += '<p id="stepInfo' + ad.id + '" class="slogan" style="height: 100%; font-size: 13px; font-weight: lighter; padding: 2px;"><div style="border:1px dashed #19b9ff;text-align: left;padding: 5px;margin-top:15px;color: #fd7741;">' + ad.step_info + '<br/>&nbsp;<span style="color:#BA8300">在未完成以上所有步骤前切勿卸载</span></div></p>';
                            } else {
                                html += '<div style="height: 20px"></div>';
                            }

                        html += '</div>';
                        html += '<div id="progress' + ad.id + '" class="progress-bar blue stripes" style="display:none"><span id="progressData' + ad.id + '"></span></div>';

                        html += '<div class="sw-des">';
                            html += '<p>' + ad.desc2 + '<br></p>';
                            html += '<p>';
                                html += '<img src="' + ad.image1 + '" width="140px"/>';
                                html += '<img src="' + ad.image2 + '" width="140px"/>';
                            html += '</p>';
                        html += '</div>';
                        html += '<div class="fun_btn black">';
                            html += '<a href="#" onclick="easoulocker.handleDownload(\'' + ad.id + '\')"  title="">立即下载安装&gt;&gt;</a>';
                        html += '</div>';
                        html += '<div class="clearfix bfont">';
                            html += ad.company;
                        html += '</div>';
                    html += '</section>';
                html += '</div>';
            html += '</div>';
        //隐藏主页
        $(".wrap").hide();

        //显示详情页
        $("#detail").show();
        $("#detail").html(html);
    };

    /**
     * 将json对象转换为字符串
     * @param jsonObject   要转换的json对象
     * @returns {string}
     */
    easoulocker.jsonToString = function(jsonObject) {
        if(jsonObject) {
            var result = "{";
            for (var item in jsonObject) {
                result += "\"" + item + "\": ";
                if (typeof jsonObject[item] == 'string') {
                    result += ("\"" + jsonObject[item] + "\", ");
                } else if (typeof jsonObject[item] == 'number') {
                    result += (jsonObject[item] + ", ");
                } else {
                    result += easoulocker.jsonToString(jsonObject[item]);
                }
            }
            var index = result.lastIndexOf(", ");
            if (index != -1) {
                result = result.substring(0, index);
            }
            result += "}";
            return result;
        } else {
            return "undefined";
        }
    };

    /**
     * 通知开始下载
     * SDK-JS交互接口，不可混淆
     * @param adid
     */
    easoulocker.startToDownload = function(adid) {
        //发送下载日志
        //由SDK负责发送下载日志，分别处理cpc和cpa的下载
//        window.eslc.sendLog(easoulocker.ad.dlog);
        //初始化下载进度
        var $progress = $("#progress" + adid);
        if ($progress) {
            $progress.show();
        }
    };

    /**
     * 用于实时显示下载进度
     * SDK-JS交互接口，不可混淆
     * @param adid
     * @param progress
     */
    easoulocker.updateProgress = function(adid, progress) {
        var $progressData = $("#progressData" + adid);
        if ($progressData) {
            $progressData.css("width", progress + "%");
            if (parseInt(progress) > 20) {
                $progressData.html("&nbsp;&nbsp;下载" + progress + "%");
            }
        }
    };

    /**
     * 通知下载完成
     * SDK-JS交互接口，不可混淆
     * @param adid
     */
    easoulocker.downloadFinish = function(adid) {
        //隐藏下载进度
        var $progress = $("#progress" + adid);
        var $progressData = $("#progressData" + adid);
        //进度信息还原
        if ($progressData) {
            $progressData.css("width", "0%");
        }
        //隐藏进度信息
        if ($progress ) {
            $progress.hide();
        }

        //发送下载完成log
        window.eslc.sendLog(easoulocker.ad.elog);
    };

    /**
     * 通知app激活
     * SDK-JS交互接口，不可混淆
     * @param adid
     */
    easoulocker.active =function(adid) {
        var ad = easoulocker.ad;
        if (ad) {
            ad.status = easoulocker.status.STATUS_INSTALLED
            ad.po = 0;
            $("#status_" + adid).children().remove();
            $("#status_" + adid).html("已安装");
            //返回到主页面
            easoulocker.returnMainPage();
        }
    };


    /**
     * app安装完成后回调
     * SDK-JS交互接口，不可混淆
     * @param adid
     */
    easoulocker.installFinish = function(adid) {
        var ad = easoulocker.ad;
        if (ad) {
            ad.status = easoulocker.status.STATUS_DOWNLOADED
        }
        //返回到主界面
        easoulocker.returnMainPage();
        $("#status_" + adid).html("已安装");
    };