/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;

public class HierarchyMatch
implements IndirectMatch {
    private String[] parentTypes;

    private HierarchyMatch(String[] parentTypes) {
        if (parentTypes == null || parentTypes.length == 0) {
            throw new IllegalArgumentException("parentTypes is null");
        }
        this.parentTypes = parentTypes;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = null;
        for (String superTypeName : this.parentTypes) {
            junction = junction == null ? this.buildSuperClassMatcher(superTypeName) : junction.and(this.buildSuperClassMatcher(superTypeName));
        }
        junction = junction.and(ElementMatchers.not(ElementMatchers.isInterface()));
        return junction;
    }

    private ElementMatcher.Junction buildSuperClassMatcher(String superTypeName) {
        return ElementMatchers.hasSuperType(ElementMatchers.named(superTypeName));
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        ArrayList<String> parentTypes = new ArrayList<String>(Arrays.asList(this.parentTypes));
        TypeList.Generic implInterfaces = typeDescription.getInterfaces();
        for (TypeDescription.Generic implInterface : implInterfaces) {
            this.matchHierarchyClass(implInterface, parentTypes);
        }
        if (typeDescription.getSuperClass() != null) {
            this.matchHierarchyClass(typeDescription.getSuperClass(), parentTypes);
        }
        return parentTypes.size() == 0;
    }

    private void matchHierarchyClass(TypeDescription.Generic clazz, List<String> parentTypes) {
        parentTypes.remove(clazz.asRawType().getTypeName());
        if (parentTypes.size() == 0) {
            return;
        }
        for (TypeDescription.Generic generic : clazz.getInterfaces()) {
            this.matchHierarchyClass(generic, parentTypes);
        }
        TypeDescription.Generic superClazz = clazz.getSuperClass();
        if (superClazz != null && !clazz.getTypeName().equals("java.lang.Object")) {
            this.matchHierarchyClass(superClazz, parentTypes);
        }
    }

    public static IndirectMatch byHierarchyMatch(String ... parentTypes) {
        return new HierarchyMatch(parentTypes);
    }
}

