/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.motan;

import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class MotanConsumerInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        objInst.setSkyWalkingDynamicField(allArguments[1]);
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        URL url = (URL)objInst.getSkyWalkingDynamicField();
        Request request = (Request)allArguments[0];
        if (url != null) {
            ContextCarrier contextCarrier = new ContextCarrier();
            String remotePeer = url.getHost() + ":" + url.getPort();
            AbstractSpan span = ContextManager.createExitSpan((String)MotanConsumerInterceptor.generateOperationName(url, request), (ContextCarrier)contextCarrier, (String)remotePeer);
            span.setComponent((Component)ComponentsDefine.MOTAN);
            Tags.URL.set(span, url.getIdentity());
            SpanLayer.asRPCFramework((AbstractSpan)span);
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                request.setAttachment(next.getHeadKey(), next.getHeadValue());
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Response response = (Response)ret;
        if (response != null && response.getException() != null) {
            AbstractSpan span = ContextManager.activeSpan();
            span.log((Throwable)response.getException());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    private static String generateOperationName(URL serviceURI, Request request) {
        return serviceURI.getPath() + "." + request.getMethodName() + "(" + request.getParamtersDesc() + ")";
    }
}

