/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.conf.dynamic.watcher;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.dynamic.AgentConfigChangeWatcher;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.sampling.SamplingService;

public class SamplingRateWatcher
extends AgentConfigChangeWatcher {
    private static final ILog LOGGER = LogManager.getLogger(SamplingRateWatcher.class);
    private final AtomicInteger samplingRate = new AtomicInteger(this.getDefaultValue());
    private final SamplingService samplingService;

    public SamplingRateWatcher(String propertyKey, SamplingService samplingService) {
        super(propertyKey);
        this.samplingService = samplingService;
    }

    private void activeSetting(String config) {
        if (LOGGER.isDebugEnable()) {
            LOGGER.debug("Updating using new static config: {}", config);
        }
        try {
            this.samplingRate.set(Integer.parseInt(config));
            this.samplingService.handleSamplingRateChanged();
        }
        catch (NumberFormatException ex) {
            LOGGER.error(ex, "Cannot load {} from: {}", this.getPropertyKey(), config);
        }
    }

    @Override
    public void notify(AgentConfigChangeWatcher.ConfigChangeEvent value) {
        if (AgentConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting(String.valueOf(this.getDefaultValue()));
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    @Override
    public String value() {
        return String.valueOf(this.samplingRate.get());
    }

    private int getDefaultValue() {
        return Config.Agent.SAMPLE_N_PER_3_SECS;
    }

    public int getSamplingRate() {
        return this.samplingRate.get();
    }
}

