/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.finagle;

import com.twitter.io.Buf;
import com.twitter.io.Bufs;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.finagle.Constants;
import org.apache.skywalking.apm.plugin.finagle.SWContextCarrier;
import org.apache.skywalking.apm.util.StringUtil;

public class CodecUtils {
    static ILog LOGGER = LogManager.getLogger(CodecUtils.class);
    private static ThreadLocal<ByteArrayOutputStream> REUSED_BOS = new ThreadLocal<ByteArrayOutputStream>(){

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(128);
        }
    };

    private static ByteArrayOutputStream getBos() {
        ByteArrayOutputStream bos = REUSED_BOS.get();
        bos.reset();
        return bos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Buf encode(SWContextCarrier swContextCarrier) {
        if (!StringUtil.isNotEmpty((String)swContextCarrier.getOperationName())) return Bufs.EMPTY;
        if (swContextCarrier.getCarrier() == null) return Bufs.EMPTY;
        ByteArrayOutputStream bos = CodecUtils.getBos();
        try (DataOutputStream dos = new DataOutputStream(bos);){
            CodecUtils.putString(dos, swContextCarrier.getOperationName());
            CarrierItem next = swContextCarrier.getCarrier().items();
            while (next.hasNext()) {
                if ((next = next.next()).getHeadKey() == null || next.getHeadValue() == null) continue;
                CodecUtils.putString(dos, next.getHeadKey());
                CodecUtils.putString(dos, next.getHeadValue());
            }
            bos.flush();
            Buf buf = Bufs.ownedBuf((byte[])bos.toByteArray());
            return buf;
        }
        catch (Exception e) {
            LOGGER.error("encode swContextCarrier exception.", (Throwable)e);
        }
        return Bufs.EMPTY;
    }

    static SWContextCarrier decode(Buf buf) {
        try {
            byte[] bytes = Bufs.ownedByteArray((Buf)buf);
            if (bytes == null || bytes.length == 0) {
                return Constants.EMPTY_SWCONTEXTCARRIER;
            }
            ContextCarrier contextCarrier = new ContextCarrier();
            SWContextCarrier swContextCarrier = new SWContextCarrier();
            swContextCarrier.setContextCarrier(contextCarrier);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            String operationName = CodecUtils.getNextString(byteBuffer);
            if (operationName != null) {
                swContextCarrier.setOperationName(operationName);
            }
            Map<String, String> data = CodecUtils.readToMap(byteBuffer);
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                next.setHeadValue(data.get(next.getHeadKey()));
            }
            return swContextCarrier;
        }
        catch (Exception e) {
            LOGGER.error("decode swContextCarrier exception.", (Throwable)e);
            return Constants.EMPTY_SWCONTEXTCARRIER;
        }
    }

    private static void putString(DataOutputStream dos, String value) throws IOException {
        byte[] bytes = CodecUtils.encodeStringToBytes(value);
        dos.writeInt(bytes.length);
        dos.write(bytes);
    }

    private static String getNextString(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining()) {
            byte[] bytes = new byte[byteBuffer.getInt()];
            byteBuffer.get(bytes);
            return CodecUtils.decodeStringFromBytes(bytes);
        }
        return null;
    }

    private static Map<String, String> readToMap(ByteBuffer byteBuffer) {
        HashMap<String, String> data = new HashMap<String, String>();
        String key = null;
        while ((key = CodecUtils.getNextString(byteBuffer)) != null) {
            data.put(key, CodecUtils.getNextString(byteBuffer));
        }
        return data;
    }

    private static byte[] encodeStringToBytes(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static String decodeStringFromBytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

