/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.jvm.JVMMetricsSender;
import org.apache.skywalking.apm.agent.core.kafka.KafkaProducerManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.JVMMetric;
import org.apache.skywalking.apm.network.language.agent.v3.JVMMetricCollection;

@OverrideImplementor(value=JVMMetricsSender.class)
public class KafkaJVMMetricsSender
extends JVMMetricsSender {
    private static final ILog LOGGER = LogManager.getLogger(KafkaJVMMetricsSender.class);
    private KafkaProducer<String, Bytes> producer;
    private String topic;
    private BlockingQueue<JVMMetric> queue;
    private volatile boolean running = false;

    public void run() {
        if (!this.queue.isEmpty()) {
            ArrayList buffer = new ArrayList();
            this.queue.drainTo(buffer);
            if (this.running) {
                JVMMetricCollection metrics = JVMMetricCollection.newBuilder().addAllMetrics(buffer).setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME).build();
                if (LOGGER.isDebugEnable()) {
                    LOGGER.debug("JVM metrics reporting, topic: {}, key: {}, length: {}", new Object[]{this.topic, metrics.getServiceInstance(), buffer.size()});
                }
                this.producer.send(new ProducerRecord<String, Bytes>(this.topic, metrics.getServiceInstance(), Bytes.wrap(metrics.toByteArray())));
                this.producer.flush();
            }
        }
    }

    public void prepare() {
        this.queue = new LinkedBlockingQueue<JVMMetric>(Config.Jvm.BUFFER_SIZE);
        this.topic = KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_METRICS;
    }

    public void boot() {
        this.producer = ((KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class)).getProducer();
        this.running = true;
    }

    public void offer(JVMMetric metric) {
        if (!this.queue.offer(metric)) {
            this.queue.poll();
            this.queue.offer(metric);
        }
    }
}

