/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterService;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.agent.core.remote.GRPCStreamServiceStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.StatusRuntimeException;
import org.apache.skywalking.apm.dependencies.io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;
import org.apache.skywalking.apm.network.language.agent.v3.MeterReportServiceGrpc;

@DefaultImplementor
public class MeterSender
implements BootService,
GRPCChannelListener {
    private static final ILog LOGGER = LogManager.getLogger(MeterSender.class);
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private volatile MeterReportServiceGrpc.MeterReportServiceStub meterReportServiceStub;

    @Override
    public void prepare() {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
    }

    @Override
    public void boot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<MeterId, BaseMeter> meterMap, MeterService meterService) {
        if (this.status == GRPCChannelStatus.CONNECTED) {
            StreamObserver<MeterData> reportStreamObserver = null;
            final GRPCStreamServiceStatus status = new GRPCStreamServiceStatus(false);
            try {
                StreamObserver<MeterData> reporter = reportStreamObserver = ((MeterReportServiceGrpc.MeterReportServiceStub)this.meterReportServiceStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS)).collect(new StreamObserver<Commands>(){

                    @Override
                    public void onNext(Commands commands) {
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        status.finished();
                        if (LOGGER.isErrorEnable()) {
                            LOGGER.error(throwable, "Send meters to collector fail with a grpc internal exception.", new Object[0]);
                        }
                        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).reportError(throwable);
                    }

                    @Override
                    public void onCompleted() {
                        status.finished();
                    }
                });
                this.transform(meterMap, meterData -> reporter.onNext((MeterData)meterData));
            }
            catch (Throwable e) {
                if (!(e instanceof StatusRuntimeException)) {
                    LOGGER.error(e, "Report meters to backend fail.", new Object[0]);
                    return;
                }
                StatusRuntimeException statusRuntimeException = (StatusRuntimeException)e;
                if (statusRuntimeException.getStatus().getCode() == Status.Code.UNIMPLEMENTED) {
                    LOGGER.warn("Backend doesn't support meter, it will be disabled", new Object[0]);
                    meterService.shutdown();
                }
            }
            finally {
                if (reportStreamObserver != null) {
                    reportStreamObserver.onCompleted();
                }
                status.wait4Finish();
            }
        }
    }

    protected void transform(Map<MeterId, BaseMeter> meterMap, Consumer<MeterData> consumer) {
        boolean hasSendMachineInfo = false;
        for (BaseMeter meter : meterMap.values()) {
            MeterData.Builder dataBuilder = meter.transform();
            if (dataBuilder == null) continue;
            if (!hasSendMachineInfo) {
                dataBuilder.setService(Config.Agent.SERVICE_NAME);
                dataBuilder.setServiceInstance(Config.Agent.INSTANCE_NAME);
                dataBuilder.setTimestamp(System.currentTimeMillis());
                hasSendMachineInfo = true;
            }
            consumer.accept(dataBuilder.build());
        }
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
            this.meterReportServiceStub = MeterReportServiceGrpc.newStub(channel);
        } else {
            this.meterReportServiceStub = null;
        }
        this.status = status;
    }
}

