/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.xerial.snappy;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.skywalking.apm.dependencies.org.xerial.snappy.PureJavaCrc32C;

final class SnappyFramed {
    public static final int COMPRESSED_DATA_FLAG = 0;
    public static final int UNCOMPRESSED_DATA_FLAG = 1;
    public static final int STREAM_IDENTIFIER_FLAG = 255;
    private static final int MASK_DELTA = -1568478504;
    static final Class<? extends ByteBuffer> DIRECT_BUFFER_CLAZZ = SnappyFramed.lookupClassQuietly("java.nio.DirectByteBuffer");
    static final MethodHandle CLEAN_HANDLE;
    public static final byte[] HEADER_BYTES;

    SnappyFramed() {
    }

    public static int maskedCrc32c(byte[] byArray) {
        return SnappyFramed.maskedCrc32c(byArray, 0, byArray.length);
    }

    public static int maskedCrc32c(byte[] byArray, int n, int n2) {
        PureJavaCrc32C pureJavaCrc32C = new PureJavaCrc32C();
        pureJavaCrc32C.update(byArray, n, n2);
        return SnappyFramed.mask(pureJavaCrc32C.getIntegerValue());
    }

    public static int mask(int n) {
        return (n >>> 15 | n << 17) + -1568478504;
    }

    static final int readBytes(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        n3 = n = readableByteChannel.read(byteBuffer);
        if (n < n2) {
            while (byteBuffer.remaining() != 0 && n != -1) {
                n = readableByteChannel.read(byteBuffer);
                if (n == -1) continue;
                n3 += n;
            }
        }
        if (n3 > 0) {
            byteBuffer.limit(byteBuffer.position());
        } else {
            byteBuffer.position(byteBuffer.limit());
        }
        return n3;
    }

    static int skip(ReadableByteChannel readableByteChannel, int n, ByteBuffer byteBuffer) throws IOException {
        if (n <= 0) {
            return 0;
        }
        int n2 = n;
        int n3 = 0;
        while (n2 > 0 && n3 != -1) {
            byteBuffer.clear();
            if (n2 < byteBuffer.capacity()) {
                byteBuffer.limit(n2);
            }
            if ((n3 = readableByteChannel.read(byteBuffer)) <= 0) continue;
            n2 -= n3;
        }
        byteBuffer.clear();
        return n - n2;
    }

    private static Class<?> lookupClassQuietly(String string) {
        try {
            return SnappyFramed.class.getClassLoader().loadClass(string);
        }
        catch (Throwable throwable) {
            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Did not find requested class: " + string, throwable);
            return null;
        }
    }

    static void releaseDirectByteBuffer(final ByteBuffer byteBuffer) {
        assert (byteBuffer != null && byteBuffer.isDirect());
        if (CLEAN_HANDLE != null && DIRECT_BUFFER_CLAZZ.isInstance(byteBuffer)) {
            try {
                PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try {
                            CLEAN_HANDLE.invokeExact(byteBuffer);
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                        return null;
                    }
                };
                AccessController.doPrivileged(privilegedExceptionAction);
            }
            catch (Throwable throwable) {
                Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Exception occurred attempting to clean up Sun specific DirectByteBuffer.", throwable);
            }
        }
    }

    static boolean nonNull(Object object) {
        return object != null;
    }

    static {
        MethodHandle methodHandle = null;
        try {
            PrivilegedExceptionAction<MethodHandle> privilegedExceptionAction = new PrivilegedExceptionAction<MethodHandle>(){

                @Override
                public MethodHandle run() throws Exception {
                    MethodHandle methodHandle = null;
                    if (DIRECT_BUFFER_CLAZZ != null) {
                        MethodHandles.Lookup lookup = MethodHandles.lookup();
                        try {
                            Class<?> clazz = Class.forName("sun.misc.Unsafe");
                            MethodHandle methodHandle2 = lookup.findVirtual(clazz, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
                            Field field = clazz.getDeclaredField("theUnsafe");
                            field.setAccessible(true);
                            Object object = field.get(null);
                            methodHandle = methodHandle2.bindTo(object);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "unable to use java 9 Unsafe.invokeCleaner", exception);
                            Method method = DIRECT_BUFFER_CLAZZ.getMethod("cleaner", new Class[0]);
                            method.setAccessible(true);
                            MethodHandle methodHandle3 = lookup.unreflect(method);
                            TypeDescriptor.OfField ofField = methodHandle3.type().returnType();
                            MethodHandle methodHandle4 = lookup.findVirtual((Class<?>)ofField, "clean", MethodType.methodType(Void.TYPE));
                            MethodHandle methodHandle5 = lookup.findStatic(SnappyFramed.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, ofField));
                            MethodHandle methodHandle6 = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{ofField});
                            methodHandle = MethodHandles.filterReturnValue(methodHandle3, MethodHandles.guardWithTest(methodHandle5, methodHandle4, methodHandle6)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                        }
                    }
                    return methodHandle;
                }
            };
            methodHandle = AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (Throwable throwable) {
            Logger.getLogger(SnappyFramed.class.getName()).log(Level.FINE, "Exception occurred attempting to lookup Sun specific DirectByteBuffer cleaner classes.", throwable);
        }
        CLEAN_HANDLE = methodHandle;
        HEADER_BYTES = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    }
}

