/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdk.http;

import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.util.StringUtil;
import sun.net.www.MessageHeader;

public class HttpClientWriteRequestInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpURLConnection connection = (HttpURLConnection)objInst.getSkyWalkingDynamicField();
        MessageHeader headers = (MessageHeader)allArguments[0];
        URL url = connection.getURL();
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)this.getPath(url), (ContextCarrier)contextCarrier, (String)this.getPeer(url));
        span.setComponent((Component)ComponentsDefine.JDK_HTTP);
        Tags.HTTP.METHOD.set(span, connection.getRequestMethod());
        Tags.URL.set(span, url.toString());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            headers.set(next.getHeadKey(), next.getHeadValue());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    private String getPeer(URL url) {
        String host = url.getHost();
        if (url.getPort() > 0) {
            return host + ":" + url.getPort();
        }
        return host;
    }

    private String getPath(URL url) {
        return StringUtil.isEmpty((String)url.getPath()) ? "/" : url.getPath();
    }
}

