/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.commands;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.commands.CommandExecutionException;
import org.apache.skywalking.apm.agent.core.commands.CommandExecutorService;
import org.apache.skywalking.apm.agent.core.commands.CommandSerialNumberCache;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.network.common.v3.Command;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.trace.component.command.BaseCommand;
import org.apache.skywalking.apm.network.trace.component.command.CommandDeserializer;
import org.apache.skywalking.apm.network.trace.component.command.UnsupportedCommandException;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@DefaultImplementor
public class CommandService
implements BootService,
Runnable {
    private static final ILog LOGGER = LogManager.getLogger(CommandService.class);
    private volatile boolean isRunning = true;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(new DefaultNamedThreadFactory("CommandService"));
    private LinkedBlockingQueue<BaseCommand> commands = new LinkedBlockingQueue(64);
    private CommandSerialNumberCache serialNumberCache = new CommandSerialNumberCache();

    @Override
    public void prepare() throws Throwable {
    }

    @Override
    public void boot() throws Throwable {
        this.executorService.submit(new RunnableWithExceptionProtection(this, t -> LOGGER.error(t, "CommandService failed to execute commands", new Object[0])));
    }

    @Override
    public void run() {
        CommandExecutorService commandExecutorService = ServiceManager.INSTANCE.findService(CommandExecutorService.class);
        while (this.isRunning) {
            try {
                BaseCommand command = this.commands.take();
                if (this.isCommandExecuted(command)) continue;
                commandExecutorService.execute(command);
                this.serialNumberCache.add(command.getSerialNumber());
            }
            catch (InterruptedException e) {
                LOGGER.error(e, "Failed to take commands.", new Object[0]);
            }
            catch (CommandExecutionException e) {
                LOGGER.error(e, "Failed to execute command[{}].", e.command().getCommand());
            }
            catch (Throwable e) {
                LOGGER.error(e, "There is unexpected exception", new Object[0]);
            }
        }
    }

    private boolean isCommandExecuted(BaseCommand command) {
        return this.serialNumberCache.contain(command.getSerialNumber());
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        this.isRunning = false;
        this.commands.drainTo(new ArrayList());
        this.executorService.shutdown();
    }

    public void receiveCommand(Commands commands) {
        for (Command command : commands.getCommandsList()) {
            try {
                BaseCommand baseCommand = CommandDeserializer.deserialize(command);
                if (this.isCommandExecuted(baseCommand)) {
                    LOGGER.warn("Command[{}] is executed, ignored", baseCommand.getCommand());
                    continue;
                }
                boolean success = this.commands.offer(baseCommand);
                if (success || !LOGGER.isWarnEnable()) continue;
                LOGGER.warn("Command[{}, {}] cannot add to command list. because the command list is full.", baseCommand.getCommand(), baseCommand.getSerialNumber());
            }
            catch (UnsupportedCommandException e) {
                if (!LOGGER.isWarnEnable()) continue;
                LOGGER.warn("Received unsupported command[{}].", e.getCommand().getCommand());
            }
        }
    }
}

