/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.ids;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.skywalking.apm.util.StringUtil;

public final class GlobalIdGenerator {
    private static final String PROCESS_ID = UUID.randomUUID().toString().replaceAll("-", "");
    private static final ThreadLocal<IDContext> THREAD_ID_SEQUENCE = ThreadLocal.withInitial(() -> new IDContext(System.currentTimeMillis(), 0));

    private GlobalIdGenerator() {
    }

    public static String generate() {
        return StringUtil.join('.', PROCESS_ID, String.valueOf(Thread.currentThread().getId()), String.valueOf(GlobalIdGenerator.THREAD_ID_SEQUENCE.get().nextSeq()));
    }

    private static class IDContext {
        private long lastTimestamp;
        private short threadSeq;
        private long runRandomTimestamp;
        private int lastRandomValue;

        private IDContext(long lastTimestamp, short threadSeq) {
            this.lastTimestamp = lastTimestamp;
            this.threadSeq = threadSeq;
        }

        private long nextSeq() {
            return this.timestamp() * 10000L + (long)this.nextThreadSeq();
        }

        private long timestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTimestamp) {
                if (this.runRandomTimestamp != currentTimeMillis) {
                    this.lastRandomValue = ThreadLocalRandom.current().nextInt();
                    this.runRandomTimestamp = currentTimeMillis;
                }
                return this.lastRandomValue;
            }
            this.lastTimestamp = currentTimeMillis;
            return this.lastTimestamp;
        }

        private short nextThreadSeq() {
            if (this.threadSeq == 10000) {
                this.threadSeq = 0;
            }
            short s = this.threadSeq;
            this.threadSeq = (short)(s + 1);
            return s;
        }
    }
}

