/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.grpc.internal;

import org.apache.skywalking.apm.dependencies.com.google.common.annotations.VisibleForTesting;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Preconditions;
import org.apache.skywalking.apm.dependencies.io.grpc.Metadata;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.ClientStreamListener;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.InsightBuilder;
import org.apache.skywalking.apm.dependencies.io.grpc.internal.NoopClientStream;

public final class FailingClientStream
extends NoopClientStream {
    private boolean started;
    private final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    public FailingClientStream(Status error) {
        this(error, ClientStreamListener.RpcProgress.PROCESSED);
    }

    public FailingClientStream(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState(!this.started, "already started");
        this.started = true;
        listener.closed(this.error, this.rpcProgress, new Metadata());
    }

    @VisibleForTesting
    Status getError() {
        return this.error;
    }

    @Override
    public void appendTimeoutInsight(InsightBuilder insight) {
        insight.appendKeyValue("error", this.error).appendKeyValue("progress", (Object)this.rpcProgress);
    }
}

