/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.trace;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.util.CustomizeExpression;
import org.apache.skywalking.apm.toolkit.activation.util.TagUtil;
import org.apache.skywalking.apm.toolkit.trace.Tag;
import org.apache.skywalking.apm.toolkit.trace.Tags;

public class BaseTagAnnotationInterceptor {
    void beforeMethod(Method method, Object[] allArguments) {
        Tag tag;
        if (!ContextManager.isActive()) {
            return;
        }
        AbstractSpan activeSpan = ContextManager.activeSpan();
        Map context = CustomizeExpression.evaluationContext((Object[])allArguments);
        Tags tags = method.getAnnotation(Tags.class);
        if (tags != null && tags.value().length > 0) {
            for (Tag tag2 : tags.value()) {
                if (TagUtil.isReturnTag(tag2.value()).booleanValue()) continue;
                TagUtil.tagParamsSpan(activeSpan, context, tag2);
            }
        }
        if ((tag = method.getAnnotation(Tag.class)) != null && !TagUtil.isReturnTag(tag.value()).booleanValue()) {
            TagUtil.tagParamsSpan(activeSpan, context, tag);
        }
    }

    void afterMethod(Method method, Object ret) {
        Tag tag;
        if (ret == null || !ContextManager.isActive()) {
            return;
        }
        AbstractSpan localSpan = ContextManager.activeSpan();
        Map context = CustomizeExpression.evaluationReturnContext((Object)ret);
        Tags tags = method.getAnnotation(Tags.class);
        if (tags != null && tags.value().length > 0) {
            for (Tag tag2 : tags.value()) {
                if (!TagUtil.isReturnTag(tag2.value()).booleanValue()) continue;
                TagUtil.tagReturnSpanSpan(localSpan, context, tag2);
            }
        }
        if ((tag = method.getAnnotation(Tag.class)) != null && TagUtil.isReturnTag(tag.value()).booleanValue()) {
            TagUtil.tagReturnSpanSpan(localSpan, context, tag);
        }
    }

    void handleMethodException(Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

