/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.Map;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.kafka.KafkaProducerManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.kafka.KafkaTraceSegmentServiceClient;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterSender;
import org.apache.skywalking.apm.agent.core.meter.MeterService;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.MeterDataCollection;

@OverrideImplementor(value=MeterSender.class)
public class KafkaMeterSender
extends MeterSender {
    private static final ILog LOGGER = LogManager.getLogger(KafkaTraceSegmentServiceClient.class);
    private String topic;
    private KafkaProducer<String, Bytes> producer;

    public void prepare() {
        this.topic = KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_METER;
    }

    public void boot() {
        this.producer = ((KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class)).getProducer();
    }

    public void send(Map<MeterId, BaseMeter> meterMap, MeterService meterService) {
        MeterDataCollection.Builder builder = MeterDataCollection.newBuilder();
        this.transform(meterMap, meterData -> {
            if (LOGGER.isDebugEnable()) {
                LOGGER.debug("Meter data reporting, instance: {}", new Object[]{meterData.getServiceInstance()});
            }
            builder.addMeterData(meterData);
        });
        this.producer.send(new ProducerRecord<String, Bytes>(this.topic, Config.Agent.INSTANCE_NAME, Bytes.wrap(builder.build().toByteArray())));
        this.producer.flush();
    }
}

