/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.AdminClient;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.KafkaFuture;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization.Serializer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization.StringSerializer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;

@DefaultImplementor
public class KafkaProducerManager
implements BootService,
Runnable {
    private static final ILog LOGGER = LogManager.getLogger(KafkaProducerManager.class);
    private KafkaProducer<String, Bytes> producer;

    public void prepare() throws Throwable {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", KafkaReporterPluginConfig.Plugin.Kafka.BOOTSTRAP_SERVERS);
        KafkaReporterPluginConfig.Plugin.Kafka.PRODUCER_CONFIG.forEach((k, v) -> properties.setProperty((String)k, (String)v));
        AdminClient adminClient = AdminClient.create(properties);
        DescribeTopicsResult topicsResult = adminClient.describeTopics(Arrays.asList(KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_MANAGEMENT, KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_METRICS, KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_PROFILING, KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_SEGMENT, KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_METER));
        Set topics = topicsResult.values().entrySet().stream().map(entry -> {
            try {
                ((KafkaFuture)entry.getValue()).get(KafkaReporterPluginConfig.Plugin.Kafka.GET_TOPIC_TIMEOUT, TimeUnit.SECONDS);
                return null;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.error((Throwable)e, "Get KAFKA topic:{} error.", new Object[]{entry.getKey()});
                return (String)entry.getKey();
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!topics.isEmpty()) {
            throw new Exception("These topics" + topics + " don't exist.");
        }
        this.producer = new KafkaProducer<String, Bytes>(properties, (Serializer<String>)new StringSerializer(), (Serializer<Bytes>)new BytesSerializer());
    }

    public void boot() {
    }

    public void onComplete() {
    }

    @Override
    public void run() {
    }

    public final KafkaProducer<String, Bytes> getProducer() {
        return this.producer;
    }

    public void shutdown() {
        this.producer.flush();
        this.producer.close();
    }
}

