/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.CommonFields;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Struct;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AddOffsetsToTxnResponse;

public class AddOffsetsToTxnRequest
extends AbstractRequest {
    private static final Schema ADD_OFFSETS_TO_TXN_REQUEST_V0;
    private static final Schema ADD_OFFSETS_TO_TXN_REQUEST_V1;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch;
    private final String consumerGroupId;

    public static Schema[] schemaVersions() {
        return new Schema[]{ADD_OFFSETS_TO_TXN_REQUEST_V0, ADD_OFFSETS_TO_TXN_REQUEST_V1};
    }

    private AddOffsetsToTxnRequest(short version, String transactionalId, long producerId, short producerEpoch, String consumerGroupId) {
        super(ApiKeys.ADD_OFFSETS_TO_TXN, version);
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.consumerGroupId = consumerGroupId;
    }

    public AddOffsetsToTxnRequest(Struct struct, short version) {
        super(ApiKeys.ADD_OFFSETS_TO_TXN, version);
        this.transactionalId = struct.get(CommonFields.TRANSACTIONAL_ID);
        this.producerId = struct.get(CommonFields.PRODUCER_ID);
        this.producerEpoch = struct.get(CommonFields.PRODUCER_EPOCH);
        this.consumerGroupId = struct.get(CommonFields.GROUP_ID);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public String consumerGroupId() {
        return this.consumerGroupId;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.ADD_OFFSETS_TO_TXN.requestSchema(this.version()));
        struct.set(CommonFields.TRANSACTIONAL_ID, this.transactionalId);
        struct.set(CommonFields.PRODUCER_ID, this.producerId);
        struct.set(CommonFields.PRODUCER_EPOCH, this.producerEpoch);
        struct.set(CommonFields.GROUP_ID, this.consumerGroupId);
        return struct;
    }

    @Override
    public AddOffsetsToTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new AddOffsetsToTxnResponse(throttleTimeMs, Errors.forException(e));
    }

    public static AddOffsetsToTxnRequest parse(ByteBuffer buffer, short version) {
        return new AddOffsetsToTxnRequest(ApiKeys.ADD_OFFSETS_TO_TXN.parseRequest(version, buffer), version);
    }

    static {
        ADD_OFFSETS_TO_TXN_REQUEST_V1 = ADD_OFFSETS_TO_TXN_REQUEST_V0 = new Schema(CommonFields.TRANSACTIONAL_ID, CommonFields.PRODUCER_ID, CommonFields.PRODUCER_EPOCH, CommonFields.GROUP_ID);
    }

    public static class Builder
    extends AbstractRequest.Builder<AddOffsetsToTxnRequest> {
        private final String transactionalId;
        private final long producerId;
        private final short producerEpoch;
        private final String consumerGroupId;

        public Builder(String transactionalId, long producerId, short producerEpoch, String consumerGroupId) {
            super(ApiKeys.ADD_OFFSETS_TO_TXN);
            this.transactionalId = transactionalId;
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.consumerGroupId = consumerGroupId;
        }

        public String consumerGroupId() {
            return this.consumerGroupId;
        }

        @Override
        public AddOffsetsToTxnRequest build(short version) {
            return new AddOffsetsToTxnRequest(version, this.transactionalId, this.producerId, this.producerEpoch, this.consumerGroupId);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=AddOffsetsToTxnRequest").append(", transactionalId=").append(this.transactionalId).append(", producerId=").append(this.producerId).append(", producerEpoch=").append(this.producerEpoch).append(", consumerGroupId=").append(this.consumerGroupId).append(")");
            return bld.toString();
        }
    }
}

