/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.redisson.v3;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.redisson.v3.util.ClassUtil;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;

public class RedisConnectionMethodInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(RedisConnectionMethodInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = (String)objInst.getSkyWalkingDynamicField();
        RedisConnection connection = (RedisConnection)objInst;
        Channel channel = connection.getChannel();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        String dbInstance = remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort();
        StringBuilder dbStatement = new StringBuilder();
        String operationName = "Redisson/";
        if (allArguments[0] instanceof CommandsData) {
            operationName = operationName + "BATCH_EXECUTE";
            CommandsData commands = (CommandsData)allArguments[0];
            for (CommandData commandData : commands.getCommands()) {
                this.addCommandData(dbStatement, commandData);
                dbStatement.append(";");
            }
        } else if (allArguments[0] instanceof CommandData) {
            CommandData commandData = (CommandData)allArguments[0];
            String command = commandData.getCommand().getName();
            operationName = operationName + command;
            this.addCommandData(dbStatement, commandData);
        }
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (String)peer);
        span.setComponent((Component)ComponentsDefine.REDISSON);
        Tags.DB_TYPE.set(span, "Redis");
        Tags.DB_INSTANCE.set(span, dbInstance);
        Tags.DB_STATEMENT.set(span, dbStatement.toString());
        SpanLayer.asCache((AbstractSpan)span);
    }

    private void addCommandData(StringBuilder dbStatement, CommandData commandData) {
        dbStatement.append(commandData.getCommand().getName());
        if (commandData.getParams() != null) {
            for (Object param : commandData.getParams()) {
                dbStatement.append(" ").append(param instanceof ByteBuf ? "?" : String.valueOf(param.toString()));
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        String peer = (String)((EnhancedInstance)allArguments[0]).getSkyWalkingDynamicField();
        if (peer == null) {
            try {
                Object address = ClassUtil.getObjectField(((RedisClient)allArguments[0]).getConfig(), "address");
                String host = (String)ClassUtil.getObjectField(address, "host");
                String port = String.valueOf(ClassUtil.getObjectField(address, "port"));
                peer = host + ":" + port;
            }
            catch (Exception e) {
                LOGGER.warn("RedisConnection create peer error: ", new Object[]{e});
            }
        }
        objInst.setSkyWalkingDynamicField((Object)peer);
    }
}

