/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.commons.datacarrier.consumer;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.skywalking.apm.commons.datacarrier.buffer.Channels;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerCannotBeCreatedException;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerThread;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IDriver;

public class ConsumeDriver<T>
implements IDriver {
    private boolean running = false;
    private ConsumerThread[] consumerThreads;
    private Channels<T> channels;
    private ReentrantLock lock;

    public ConsumeDriver(String name, Channels<T> channels, Class<? extends IConsumer<T>> consumerClass, int num, long consumeCycle) {
        this(channels, num);
        for (int i = 0; i < num; ++i) {
            this.consumerThreads[i] = new ConsumerThread<T>("DataCarrier." + name + ".Consumer." + i + ".Thread", super.getNewConsumerInstance(consumerClass), consumeCycle);
            this.consumerThreads[i].setDaemon(true);
        }
    }

    public ConsumeDriver(String name, Channels<T> channels, IConsumer<T> prototype, int num, long consumeCycle) {
        this(channels, num);
        prototype.init();
        for (int i = 0; i < num; ++i) {
            this.consumerThreads[i] = new ConsumerThread<T>("DataCarrier." + name + ".Consumer." + i + ".Thread", prototype, consumeCycle);
            this.consumerThreads[i].setDaemon(true);
        }
    }

    private ConsumeDriver(Channels<T> channels, int num) {
        this.channels = channels;
        this.consumerThreads = new ConsumerThread[num];
        this.lock = new ReentrantLock();
    }

    private IConsumer<T> getNewConsumerInstance(Class<? extends IConsumer<T>> consumerClass) {
        try {
            IConsumer<T> inst = consumerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            inst.init();
            return inst;
        }
        catch (InstantiationException e) {
            throw new ConsumerCannotBeCreatedException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConsumerCannotBeCreatedException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConsumerCannotBeCreatedException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConsumerCannotBeCreatedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(Channels channels) {
        if (this.running) {
            return;
        }
        this.lock.lock();
        try {
            this.allocateBuffer2Thread();
            for (ConsumerThread consumerThread : this.consumerThreads) {
                consumerThread.start();
            }
            this.running = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isRunning(Channels channels) {
        return this.running;
    }

    private void allocateBuffer2Thread() {
        int channelSize = this.channels.getChannelSize();
        for (int channelIndex = 0; channelIndex < channelSize; ++channelIndex) {
            int consumerIndex = channelIndex % this.consumerThreads.length;
            this.consumerThreads[consumerIndex].addDataSource(this.channels.getBuffer(channelIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Channels channels) {
        this.lock.lock();
        try {
            this.running = false;
            for (ConsumerThread consumerThread : this.consumerThreads) {
                consumerThread.shutdown();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

