/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.CommonFields;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Struct;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.CollectionUtils;

public class AlterReplicaLogDirsResponse
extends AbstractResponse {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema ALTER_REPLICA_LOG_DIRS_RESPONSE_V0;
    private static final Schema ALTER_REPLICA_LOG_DIRS_RESPONSE_V1;
    private final Map<TopicPartition, Errors> responses;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{ALTER_REPLICA_LOG_DIRS_RESPONSE_V0, ALTER_REPLICA_LOG_DIRS_RESPONSE_V1};
    }

    public AlterReplicaLogDirsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.responses = new HashMap<TopicPartition, Errors>();
        for (Object topicStructObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicStruct = (Struct)topicStructObj;
            String topic = topicStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionStructObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionStructObj;
                int partition = partitionStruct.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionStruct.get(CommonFields.ERROR_CODE));
                this.responses.put(new TopicPartition(topic, partition), error);
            }
        }
    }

    public AlterReplicaLogDirsResponse(int throttleTimeMs, Map<TopicPartition, Errors> responses) {
        this.throttleTimeMs = throttleTimeMs;
        this.responses = responses;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.ALTER_REPLICA_LOG_DIRS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> responsesByTopic = CollectionUtils.groupPartitionDataByTopic(this.responses);
        ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Errors>> responsesByTopicEntry : responsesByTopic.entrySet()) {
            Struct topicStruct = struct.instance(TOPICS_KEY_NAME);
            topicStruct.set(CommonFields.TOPIC_NAME, responsesByTopicEntry.getKey());
            ArrayList<Struct> partitionStructArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Errors> responsesByPartitionEntry : responsesByTopicEntry.getValue().entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS_KEY_NAME);
                Errors response = responsesByPartitionEntry.getValue();
                partitionStruct.set(CommonFields.PARTITION_ID, responsesByPartitionEntry.getKey());
                partitionStruct.set(CommonFields.ERROR_CODE, response.code());
                partitionStructArray.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS_KEY_NAME, (Object)partitionStructArray.toArray());
            topicStructArray.add(topicStruct);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> responses() {
        return this.responses;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.responses.values());
    }

    public static AlterReplicaLogDirsResponse parse(ByteBuffer buffer, short version) {
        return new AlterReplicaLogDirsResponse(ApiKeys.ALTER_REPLICA_LOG_DIRS.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        ALTER_REPLICA_LOG_DIRS_RESPONSE_V1 = ALTER_REPLICA_LOG_DIRS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(TOPICS_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE)))))));
    }
}

