/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.context.TracingContextListener;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.core.kafka.KafkaProducerManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.TraceSegmentServiceClient;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;

@OverrideImplementor(value=TraceSegmentServiceClient.class)
public class KafkaTraceSegmentServiceClient
implements BootService,
IConsumer<TraceSegment>,
TracingContextListener {
    private static final ILog LOGGER = LogManager.getLogger(KafkaTraceSegmentServiceClient.class);
    private String topic;
    private KafkaProducer<String, Bytes> producer;
    private volatile DataCarrier<TraceSegment> carrier;

    public void prepare() {
        this.topic = KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_SEGMENT;
    }

    public void boot() {
        this.carrier = new DataCarrier(Config.Buffer.CHANNEL_SIZE, Config.Buffer.BUFFER_SIZE, BufferStrategy.IF_POSSIBLE);
        this.carrier.consume((IConsumer)this, 1);
        this.producer = ((KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class)).getProducer();
    }

    public void onComplete() {
        TracingContext.ListenerManager.add((TracingContextListener)this);
    }

    public void shutdown() {
        TracingContext.ListenerManager.remove((TracingContextListener)this);
        this.carrier.shutdownConsumers();
    }

    public void init() {
    }

    public void consume(List<TraceSegment> data) {
        data.forEach(traceSegment -> {
            SegmentObject upstreamSegment = traceSegment.transform();
            ProducerRecord<String, Bytes> record = new ProducerRecord<String, Bytes>(this.topic, upstreamSegment.getTraceSegmentId(), Bytes.wrap(upstreamSegment.toByteArray()));
            this.producer.send(record, (m, e) -> {
                if (Objects.nonNull(e)) {
                    LOGGER.error("Failed to report TraceSegment.", (Throwable)e);
                }
            });
        });
    }

    public void onError(List<TraceSegment> data, Throwable t) {
        LOGGER.error(t, "Try to send {} trace segments to collector, with unexpected exception.", new Object[]{data.size()});
    }

    public void onExit() {
    }

    public void afterFinished(TraceSegment traceSegment) {
        if (LOGGER.isDebugEnable()) {
            LOGGER.debug("Trace segment reporting, traceId: {}", new Object[]{traceSegment.getTraceSegmentId()});
        }
        if (traceSegment.isIgnore()) {
            LOGGER.debug("Trace[TraceId={}] is ignored.", new Object[]{traceSegment.getTraceSegmentId()});
            return;
        }
        this.carrier.produce((Object)traceSegment);
    }
}

