/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.thrift.client;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.thrift.commons.ReflectionUtils;
import org.apache.skywalking.apm.plugin.thrift.wrapper.ClientOutProtocolWrapper;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TProtocol;

public class TServiceClientInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    private static final StringTag TAG_ARGS = new StringTag("args");

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws NoSuchFieldException, IllegalAccessException {
        if (!(allArguments[1] instanceof ClientOutProtocolWrapper)) {
            TProtocol protocol = (TProtocol)allArguments[1];
            ReflectionUtils.setValue(TServiceClient.class, objInst, "oprot_", (Object)new ClientOutProtocolWrapper(protocol));
            Object dynamicField = ((EnhancedInstance)protocol.getTransport()).getSkyWalkingDynamicField();
            objInst.setSkyWalkingDynamicField(Objects.isNull(dynamicField) ? "UNKNOWN" : dynamicField);
        }
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span = ContextManager.createExitSpan((String)(objInst.getClass().getName() + "." + allArguments[0]), (String)((String)objInst.getSkyWalkingDynamicField()));
        SpanLayer.asRPCFramework((AbstractSpan)span);
        span.setComponent((Component)ComponentsDefine.THRIFT_CLIENT);
        span.tag((AbstractTag)TAG_ARGS, this.getArguments((String)allArguments[0], (TBase)allArguments[1]));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private String getArguments(String method, TBase base) {
        TFieldIdEnum field;
        int idx = 0;
        StringBuilder buffer = new StringBuilder(method).append("(");
        while ((field = base.fieldForId(++idx)) != null) {
            buffer.append(field.getFieldName()).append(", ");
        }
        if (--idx > 0) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        return buffer.append(")").toString();
    }
}

