/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.thrift.wrapper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.thrift.wrapper.AbstractContext;
import org.apache.skywalking.apm.plugin.thrift.wrapper.AbstractProtocolWrapper;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;

public class ServerInProtocolWrapper
extends AbstractProtocolWrapper {
    private static final ILog LOGGER = LogManager.getLogger(ServerInProtocolWrapper.class);
    private static final StringTag TAG_ARGS = new StringTag("args");
    private AbstractContext context;
    private static final String HAVE_CREATED_SPAN = "HAVE_CREATED_SPAN";

    public ServerInProtocolWrapper(TProtocol protocol) {
        super(protocol);
    }

    public void initial(AbstractContext context) {
        this.context = context;
        ContextManager.getRuntimeContext().put((Object)HAVE_CREATED_SPAN, (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TField readFieldBegin() throws TException {
        Boolean haveCreatedSpan;
        TField field = super.readFieldBegin();
        if (field.id == 8888 && field.type == 13) {
            try {
                TMap tMap = super.readMapBegin();
                HashMap<String, String> header = new HashMap<String, String>(tMap.size);
                for (int i = 0; i < tMap.size; ++i) {
                    header.put(this.readString(), this.readString());
                }
                AbstractSpan span = ContextManager.createEntrySpan((String)this.context.getOperatorName(), (ContextCarrier)this.createContextCarrier(header));
                span.start(this.context.startTime);
                span.tag((AbstractTag)TAG_ARGS, this.context.getArguments());
                span.setComponent((Component)ComponentsDefine.THRIFT_SERVER);
                SpanLayer.asRPCFramework((AbstractSpan)span);
                ContextManager.getRuntimeContext().put((Object)HAVE_CREATED_SPAN, (Object)true);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to resolve header or create EntrySpan.", throwable);
            }
            finally {
                this.context = null;
                super.readMapEnd();
                super.readFieldEnd();
            }
            return this.readFieldBegin();
        }
        if (field.type == 0 && (haveCreatedSpan = (Boolean)ContextManager.getRuntimeContext().get((Object)HAVE_CREATED_SPAN)) != null && !haveCreatedSpan.booleanValue()) {
            try {
                AbstractSpan span = ContextManager.createEntrySpan((String)this.context.getOperatorName(), (ContextCarrier)this.createContextCarrier(null));
                span.start(this.context.startTime);
                span.tag((AbstractTag)TAG_ARGS, this.context.getArguments());
                span.setComponent((Component)ComponentsDefine.THRIFT_SERVER);
                SpanLayer.asRPCFramework((AbstractSpan)span);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to create EntrySpan.", throwable);
            }
            finally {
                this.context = null;
            }
        }
        return field;
    }

    private ContextCarrier createContextCarrier(Map<String, String> header) {
        ContextCarrier carrier = new ContextCarrier();
        if (Objects.nonNull(header)) {
            CarrierItem items = carrier.items();
            while (items.hasNext()) {
                items = items.next();
                items.setHeadValue(header.get(items.getHeadKey()));
            }
        }
        return carrier;
    }

    public TMessage readMessageBegin() throws TException {
        TMessage message = super.readMessageBegin();
        if (Objects.nonNull(message)) {
            this.context.setup(message.name);
        }
        return message;
    }
}

