/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v21x;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.function.BiFunction;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.cloud.gateway.v21x.define.EnhanceObjectCache;
import org.apache.skywalking.apm.util.StringUtil;
import org.reactivestreams.Publisher;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClientRequest;

public class HttpClientFinalizerSendInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhanceObjectCache enhanceObjectCache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
        AbstractSpan span = ContextManager.activeSpan();
        span.prepareForAsync();
        if (!StringUtil.isEmpty((String)enhanceObjectCache.getUrl())) {
            URL url = new URL(enhanceObjectCache.getUrl());
            final ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan abstractSpan = ContextManager.createExitSpan((String)"SpringCloudGateway/sendRequest", (ContextCarrier)contextCarrier, (String)this.getPeer(url));
            Tags.URL.set(abstractSpan, enhanceObjectCache.getUrl());
            abstractSpan.prepareForAsync();
            abstractSpan.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
            abstractSpan.setLayer(SpanLayer.HTTP);
            ContextManager.stopSpan((AbstractSpan)abstractSpan);
            ContextManager.stopSpan((AbstractSpan)span);
            final BiFunction finalSender = (BiFunction)allArguments[0];
            allArguments[0] = new BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>>(){

                @Override
                public Publisher<Void> apply(HttpClientRequest request, NettyOutbound outbound) {
                    Publisher publisher = (Publisher)finalSender.apply(request, outbound);
                    CarrierItem next = contextCarrier.items();
                    while (next.hasNext()) {
                        next = next.next();
                        request.requestHeaders().remove(next.getHeadKey());
                        request.requestHeaders().set(next.getHeadKey(), (Object)next.getHeadValue());
                    }
                    return publisher;
                }
            };
            enhanceObjectCache.setCacheSpan(abstractSpan);
        }
        enhanceObjectCache.setSpan1(span);
    }

    private String getPeer(URL url) {
        return url.getHost() + ":" + url.getPort();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ((EnhancedInstance)ret).setSkyWalkingDynamicField(objInst.getSkyWalkingDynamicField());
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

