/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.mysql;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;
import org.apache.skywalking.apm.util.StringUtil;

public class ConnectionCache {
    private static final ConcurrentHashMap<String, ConnectionInfo> CONNECTIONS_MAP = new ConcurrentHashMap();
    private static final String CONNECTION_SPLIT_STR = ",";

    public static ConnectionInfo get(String host, String port) {
        String connStr = String.format("%s:%s", host, port);
        return CONNECTIONS_MAP.get(connStr);
    }

    public static void save(ConnectionInfo connectionInfo) {
        for (String conn : connectionInfo.getDatabasePeer().split(CONNECTION_SPLIT_STR)) {
            if (StringUtil.isEmpty((String)conn)) continue;
            CONNECTIONS_MAP.putIfAbsent(conn, connectionInfo);
        }
    }
}

