/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.kafka;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.util.StringUtil;

public class ProducerConstructorMapInterceptor
implements InstanceConstructorInterceptor {
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        Map config = (Map)allArguments[0];
        if (objInst.getSkyWalkingDynamicField() == null) {
            Object bootstrapServers = config.get("bootstrap.servers");
            if (bootstrapServers instanceof List) {
                objInst.setSkyWalkingDynamicField((Object)String.join((CharSequence)";", (List)bootstrapServers));
            } else {
                objInst.setSkyWalkingDynamicField((Object)StringUtil.join((char)';', (String[])COMMA_WITH_WHITESPACE.split((String)bootstrapServers, -1)));
            }
        }
    }
}

