/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.v5;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.ReactiveRequestHolder;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.ReactiveResponseHolder;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvokeInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        ReactiveResponseHolder responseHolder = new ReactiveResponseHolder(exchange.getResponse());
        ContextManager.getRuntimeContext().put((Object)"SW_RESPONSE", (Object)responseHolder);
        ContextManager.getRuntimeContext().put((Object)"SW_REQUEST", (Object)new ReactiveRequestHolder(exchange.getRequest()));
        objInst.setSkyWalkingDynamicField((Object)responseHolder);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        return ((Mono)ret).doFinally(s -> {
            ReactiveResponseHolder responseHolder = (ReactiveResponseHolder)objInst.getSkyWalkingDynamicField();
            AbstractSpan span = responseHolder.getSpan();
            if (span == null) {
                return;
            }
            HttpStatus httpStatus = exchange.getResponse().getStatusCode();
            if (httpStatus != null && httpStatus.isError()) {
                span.errorOccurred();
                Tags.STATUS_CODE.set(span, Integer.toString(httpStatus.value()));
            }
            span.asyncFinish();
        });
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

