/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.kotlin.coroutine;

import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

class TracingRunnable
implements Runnable {
    private static final String COROUTINE = "/Kotlin/Coroutine";
    private ContextSnapshot snapshot;
    private Runnable delegate;

    private TracingRunnable(ContextSnapshot snapshot, Runnable delegate) {
        this.snapshot = snapshot;
        this.delegate = delegate;
    }

    public static Runnable wrapOrNot(Runnable delegate) {
        if (ContextManager.isActive()) {
            return new TracingRunnable(ContextManager.capture(), delegate);
        }
        return delegate;
    }

    @Override
    public void run() {
        if (ContextManager.isActive() && this.snapshot.isFromCurrent()) {
            this.delegate.run();
            return;
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)COROUTINE);
        span.setComponent((Component)ComponentsDefine.KT_COROUTINE);
        ContextManager.continued((ContextSnapshot)this.snapshot);
        try {
            this.delegate.run();
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)span);
        }
    }
}

