/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v20x;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.cloud.gateway.v20x.define.EnhanceCacheObject;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public class HttpClientRequestInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        URL url = new URL((String)allArguments[1]);
        final ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan abstractSpan = ContextManager.createExitSpan((String)"SpringCloudGateway/sendRequest", (ContextCarrier)contextCarrier, (String)this.getPeer(url));
        abstractSpan.prepareForAsync();
        Tags.URL.set(abstractSpan, String.valueOf(allArguments[1]));
        abstractSpan.setLayer(SpanLayer.HTTP);
        abstractSpan.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
        ContextManager.stopSpan((AbstractSpan)abstractSpan);
        final Function handler = (Function)allArguments[2];
        allArguments[2] = new Function<HttpClientRequest, Publisher<Void>>(){

            @Override
            public Publisher<Void> apply(HttpClientRequest httpClientRequest) {
                CarrierItem next = contextCarrier.items();
                if (httpClientRequest instanceof EnhancedInstance) {
                    ((EnhancedInstance)httpClientRequest).setSkyWalkingDynamicField((Object)next);
                }
                return (Publisher)handler.apply(httpClientRequest);
            }
        };
        objInst.setSkyWalkingDynamicField((Object)new EnhanceCacheObject(span, abstractSpan));
    }

    public Object afterMethod(final EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        final EnhanceCacheObject enhanceCacheObject = (EnhanceCacheObject)objInst.getSkyWalkingDynamicField();
        Mono responseMono = (Mono)ret;
        return responseMono.doAfterSuccessOrError((BiConsumer)new BiConsumer<HttpClientResponse, Throwable>(){

            @Override
            public void accept(HttpClientResponse httpClientResponse, Throwable throwable) {
                AbstractSpan abstractSpan = enhanceCacheObject.getSendSpan();
                if (abstractSpan != null) {
                    if (throwable != null) {
                        abstractSpan.log(throwable);
                    } else if (httpClientResponse.status().code() > 400) {
                        abstractSpan.errorOccurred();
                    }
                    Tags.STATUS_CODE.set(abstractSpan, String.valueOf(httpClientResponse.status().code()));
                    abstractSpan.asyncFinish();
                }
                objInst.setSkyWalkingDynamicField(null);
                enhanceCacheObject.getFilterSpan().asyncFinish();
            }
        });
    }

    private String getPeer(URL url) {
        return url.getHost() + ":" + url.getPort();
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

