/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.KafkaException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.BufferSupplier;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.KafkaLZ4BlockInputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.KafkaLZ4BlockOutputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteBufferOutputStream;

public enum CompressionType {
    NONE(0, "none", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            return buffer;
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            return new ByteBufferInputStream(buffer);
        }
    }
    ,
    GZIP(1, "gzip", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            try {
                return new BufferedOutputStream(new GZIPOutputStream((OutputStream)buffer, 8192), 16384);
            }
            catch (Exception e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            try {
                return new BufferedInputStream(new GZIPInputStream((InputStream)new ByteBufferInputStream(buffer), 8192), 16384);
            }
            catch (Exception e) {
                throw new KafkaException(e);
            }
        }
    }
    ,
    SNAPPY(2, "snappy", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            try {
                return SnappyConstructors.OUTPUT.invoke(buffer);
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            try {
                return SnappyConstructors.INPUT.invoke(new ByteBufferInputStream(buffer));
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }
    }
    ,
    LZ4(3, "lz4", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            try {
                return new KafkaLZ4BlockOutputStream((OutputStream)buffer, messageVersion == 0);
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public InputStream wrapForInput(ByteBuffer inputBuffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            try {
                return new KafkaLZ4BlockInputStream(inputBuffer, decompressionBufferSupplier, messageVersion == 0);
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }
    }
    ,
    ZSTD(4, "zstd", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            try {
                return ZstdConstructors.OUTPUT.invoke(buffer);
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            try {
                return ZstdConstructors.INPUT.invoke(new ByteBufferInputStream(buffer));
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }
    };

    public final int id;
    public final String name;
    public final float rate;

    private CompressionType(int id, String name, float rate) {
        this.id = id;
        this.name = name;
        this.rate = rate;
    }

    public abstract OutputStream wrapForOutput(ByteBufferOutputStream var1, byte var2);

    public abstract InputStream wrapForInput(ByteBuffer var1, byte var2, BufferSupplier var3);

    public static CompressionType forId(int id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 1: {
                return GZIP;
            }
            case 2: {
                return SNAPPY;
            }
            case 3: {
                return LZ4;
            }
            case 4: {
                return ZSTD;
            }
        }
        throw new IllegalArgumentException("Unknown compression type id: " + id);
    }

    public static CompressionType forName(String name) {
        if (CompressionType.NONE.name.equals(name)) {
            return NONE;
        }
        if (CompressionType.GZIP.name.equals(name)) {
            return GZIP;
        }
        if (CompressionType.SNAPPY.name.equals(name)) {
            return SNAPPY;
        }
        if (CompressionType.LZ4.name.equals(name)) {
            return LZ4;
        }
        if (CompressionType.ZSTD.name.equals(name)) {
            return ZSTD;
        }
        throw new IllegalArgumentException("Unknown compression name: " + name);
    }

    private static MethodHandle findConstructor(String className, MethodType methodType) {
        try {
            return MethodHandles.publicLookup().findConstructor(Class.forName(className), methodType);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ MethodHandle access$100(String x0, MethodType x1) {
        return CompressionType.findConstructor(x0, x1);
    }

    private static class ZstdConstructors {
        static final MethodHandle INPUT = CompressionType.access$100("org.apache.skywalking.apm.dependencies.com.github.luben.zstd.ZstdInputStream", MethodType.methodType(Void.TYPE, InputStream.class));
        static final MethodHandle OUTPUT = CompressionType.access$100("org.apache.skywalking.apm.dependencies.com.github.luben.zstd.ZstdOutputStream", MethodType.methodType(Void.TYPE, OutputStream.class));

        private ZstdConstructors() {
        }
    }

    private static class SnappyConstructors {
        static final MethodHandle INPUT = CompressionType.access$100("org.apache.skywalking.apm.dependencies.org.xerial.snappy.SnappyInputStream", MethodType.methodType(Void.TYPE, InputStream.class));
        static final MethodHandle OUTPUT = CompressionType.access$100("org.apache.skywalking.apm.dependencies.org.xerial.snappy.SnappyOutputStream", MethodType.methodType(Void.TYPE, OutputStream.class));

        private SnappyConstructors() {
        }
    }
}

