/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.patch;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public class AutowiredAnnotationProcessorInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Class beanClass = (Class)allArguments[0];
        if (EnhancedInstance.class.isAssignableFrom(beanClass)) {
            Map candidateConstructorsCache = (Map)objInst.getSkyWalkingDynamicField();
            Constructor[] candidateConstructors = (Constructor[])candidateConstructorsCache.get(beanClass);
            if (candidateConstructors == null) {
                Constructor[] returnCandidateConstructors = (Constructor[])ret;
                if (returnCandidateConstructors == null) {
                    Constructor<?>[] rawConstructor = beanClass.getDeclaredConstructors();
                    ArrayList candidateRawConstructors = new ArrayList();
                    for (Constructor<?> constructor : rawConstructor) {
                        if (Modifier.isPrivate(constructor.getModifiers())) continue;
                        candidateRawConstructors.add(constructor);
                    }
                    candidateConstructors = candidateRawConstructors.size() == 1 && ((Constructor)candidateRawConstructors.get(0)).getParameterTypes().length > 0 ? new Constructor[]{(Constructor)candidateRawConstructors.get(0)} : new Constructor[]{};
                } else {
                    candidateConstructors = returnCandidateConstructors;
                }
                candidateConstructorsCache.put(beanClass, candidateConstructors);
            }
            return candidateConstructors.length > 0 ? candidateConstructors : null;
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        ConcurrentHashMap candidateConstructorsCache = new ConcurrentHashMap(20);
        objInst.setSkyWalkingDynamicField(candidateConstructorsCache);
    }
}

