/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.pulsar;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.pulsar.SendCallbackEnhanceRequiredInfo;

public class SendCallbackInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String OPERATION_NAME = "Pulsar/Producer/Callback";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SendCallbackEnhanceRequiredInfo requiredInfo = (SendCallbackEnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
        if (null != requiredInfo.getContextSnapshot()) {
            AbstractSpan activeSpan = ContextManager.createLocalSpan((String)OPERATION_NAME);
            activeSpan.setComponent((Component)ComponentsDefine.PULSAR_PRODUCER);
            Tags.MQ_TOPIC.set(activeSpan, requiredInfo.getTopic());
            SpanLayer.asMQ((AbstractSpan)activeSpan);
            ContextManager.continued((ContextSnapshot)requiredInfo.getContextSnapshot());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        SendCallbackEnhanceRequiredInfo requiredInfo = (SendCallbackEnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
        if (null != requiredInfo.getContextSnapshot()) {
            Exception exceptions = (Exception)allArguments[0];
            if (exceptions != null) {
                ContextManager.activeSpan().log((Throwable)exceptions);
            }
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        SendCallbackEnhanceRequiredInfo requiredInfo = (SendCallbackEnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
        if (null != requiredInfo.getContextSnapshot()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

