/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.light4j;

import com.networknt.exception.ExceptionHandler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.OrchestrationHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.light4j.Light4JPluginConfig;

public class HandleRequestInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        if (this.isExceptionHandler(objInst)) {
            HttpServerExchange exchange = (HttpServerExchange)allArguments[0];
            if (exchange.isInIoThread()) {
                String operationName = exchange.getRequestPath() + "@" + exchange.getRequestMethod();
                HeaderMap headers = exchange.getRequestHeaders();
                ContextCarrier contextCarrier = new ContextCarrier();
                CarrierItem next = contextCarrier.items();
                while (next.hasNext()) {
                    next = next.next();
                    next.setHeadValue(headers.getFirst(next.getHeadKey()));
                }
                AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
                Tags.URL.set(span, exchange.getRequestURL());
                Tags.HTTP.METHOD.set(span, exchange.getRequestMethod().toString());
                span.setComponent((Component)ComponentsDefine.LIGHT_4J);
                SpanLayer.asHttp((AbstractSpan)span);
                if (exchange.getStatusCode() >= 400) {
                    span.errorOccurred();
                    Tags.STATUS_CODE.set(span, String.valueOf(exchange.getStatusCode()));
                }
                ContextManager.stopSpan((AbstractSpan)span);
                objInst.setSkyWalkingDynamicField((Object)ContextManager.capture());
            } else if (Light4JPluginConfig.Plugin.Light4J.TRACE_HANDLER_CHAIN) {
                String operationName = objInst.getClass().getName() + "." + method.getName();
                ContextSnapshot snapshot = (ContextSnapshot)objInst.getSkyWalkingDynamicField();
                ContextManager.createLocalSpan((String)operationName).setComponent((Component)ComponentsDefine.LIGHT_4J);
                ContextManager.continued((ContextSnapshot)snapshot);
            }
        } else if (Light4JPluginConfig.Plugin.Light4J.TRACE_HANDLER_CHAIN && (this.isMiddlewareHandler(objInst) || this.isBusinessHandler(objInst))) {
            String operationName = objInst.getClass().getName() + "." + method.getName();
            ContextManager.createLocalSpan((String)operationName).setComponent((Component)ComponentsDefine.LIGHT_4J);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        if (this.isExceptionHandler(objInst)) {
            HttpServerExchange exchange = (HttpServerExchange)allArguments[0];
            if (Light4JPluginConfig.Plugin.Light4J.TRACE_HANDLER_CHAIN && !exchange.isInIoThread()) {
                ContextManager.stopSpan();
            }
        } else if (Light4JPluginConfig.Plugin.Light4J.TRACE_HANDLER_CHAIN && (this.isMiddlewareHandler(objInst) || this.isBusinessHandler(objInst))) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private boolean isBusinessHandler(EnhancedInstance objInst) {
        return !objInst.getClass().getInterfaces()[0].equals(MiddlewareHandler.class) && !objInst.getClass().equals(OrchestrationHandler.class);
    }

    private boolean isMiddlewareHandler(EnhancedInstance objInst) {
        return objInst.getClass().getInterfaces()[0].equals(MiddlewareHandler.class);
    }

    private boolean isExceptionHandler(EnhancedInstance objInst) {
        return objInst.getClass().equals(ExceptionHandler.class);
    }
}

